/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovOfflineModel;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of the registration of an entity to a Project.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectBeneficiary
extends EgovOfflineModel {
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="beneficiaryId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String beneficiaryId = null;
    @JsonProperty(value="dateOfRegistration")
    @Min(value=0L, message="Date must be greater than or equal to 0")
    private @Min(value=0L, message="Date must be greater than or equal to 0") Long dateOfRegistration = null;
    @JsonProperty(value="beneficiaryClientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String beneficiaryClientReferenceId = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="tag")
    private String tag;

    protected ProjectBeneficiary(ProjectBeneficiaryBuilder<?, ?> b) {
        super((EgovOfflineModel.EgovOfflineModelBuilder<?, ?>)b);
        this.projectId = b.projectId;
        this.beneficiaryId = b.beneficiaryId;
        this.dateOfRegistration = b.dateOfRegistration;
        this.beneficiaryClientReferenceId = b.beneficiaryClientReferenceId;
        this.isDeleted = b.isDeleted;
        this.tag = b.tag;
    }

    public static ProjectBeneficiaryBuilder<?, ?> builder() {
        return new ProjectBeneficiaryBuilderImpl();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getBeneficiaryId() {
        return this.beneficiaryId;
    }

    public Long getDateOfRegistration() {
        return this.dateOfRegistration;
    }

    public String getBeneficiaryClientReferenceId() {
        return this.beneficiaryClientReferenceId;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public String getTag() {
        return this.tag;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="beneficiaryId")
    public void setBeneficiaryId(String beneficiaryId) {
        this.beneficiaryId = beneficiaryId;
    }

    @JsonProperty(value="dateOfRegistration")
    public void setDateOfRegistration(Long dateOfRegistration) {
        this.dateOfRegistration = dateOfRegistration;
    }

    @JsonProperty(value="beneficiaryClientReferenceId")
    public void setBeneficiaryClientReferenceId(String beneficiaryClientReferenceId) {
        this.beneficiaryClientReferenceId = beneficiaryClientReferenceId;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="tag")
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectBeneficiary)) {
            return false;
        }
        ProjectBeneficiary other = (ProjectBeneficiary)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$dateOfRegistration = this.getDateOfRegistration();
        Long other$dateOfRegistration = other.getDateOfRegistration();
        if (this$dateOfRegistration == null ? other$dateOfRegistration != null : !((Object)this$dateOfRegistration).equals(other$dateOfRegistration)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$beneficiaryId = this.getBeneficiaryId();
        String other$beneficiaryId = other.getBeneficiaryId();
        if (this$beneficiaryId == null ? other$beneficiaryId != null : !this$beneficiaryId.equals(other$beneficiaryId)) {
            return false;
        }
        String this$beneficiaryClientReferenceId = this.getBeneficiaryClientReferenceId();
        String other$beneficiaryClientReferenceId = other.getBeneficiaryClientReferenceId();
        if (this$beneficiaryClientReferenceId == null ? other$beneficiaryClientReferenceId != null : !this$beneficiaryClientReferenceId.equals(other$beneficiaryClientReferenceId)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        return !(this$tag == null ? other$tag != null : !this$tag.equals(other$tag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectBeneficiary;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $dateOfRegistration = this.getDateOfRegistration();
        result = result * 59 + ($dateOfRegistration == null ? 43 : ((Object)$dateOfRegistration).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $beneficiaryId = this.getBeneficiaryId();
        result = result * 59 + ($beneficiaryId == null ? 43 : $beneficiaryId.hashCode());
        String $beneficiaryClientReferenceId = this.getBeneficiaryClientReferenceId();
        result = result * 59 + ($beneficiaryClientReferenceId == null ? 43 : $beneficiaryClientReferenceId.hashCode());
        String $tag = this.getTag();
        result = result * 59 + ($tag == null ? 43 : $tag.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectBeneficiary(projectId=" + this.getProjectId() + ", beneficiaryId=" + this.getBeneficiaryId() + ", dateOfRegistration=" + this.getDateOfRegistration() + ", beneficiaryClientReferenceId=" + this.getBeneficiaryClientReferenceId() + ", isDeleted=" + this.getIsDeleted() + ", tag=" + this.getTag() + ")";
    }

    public ProjectBeneficiary() {
    }

    public ProjectBeneficiary(String projectId, String beneficiaryId, Long dateOfRegistration, String beneficiaryClientReferenceId, Boolean isDeleted, String tag) {
        this.projectId = projectId;
        this.beneficiaryId = beneficiaryId;
        this.dateOfRegistration = dateOfRegistration;
        this.beneficiaryClientReferenceId = beneficiaryClientReferenceId;
        this.isDeleted = isDeleted;
        this.tag = tag;
    }

    public static abstract class ProjectBeneficiaryBuilder<C extends ProjectBeneficiary, B extends ProjectBeneficiaryBuilder<C, B>>
    extends EgovOfflineModel.EgovOfflineModelBuilder<C, B> {
        private String projectId;
        private String beneficiaryId;
        private Long dateOfRegistration;
        private String beneficiaryClientReferenceId;
        private Boolean isDeleted;
        private String tag;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="projectId")
        public B projectId(String projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        @JsonProperty(value="beneficiaryId")
        public B beneficiaryId(String beneficiaryId) {
            this.beneficiaryId = beneficiaryId;
            return (B)this.self();
        }

        @JsonProperty(value="dateOfRegistration")
        public B dateOfRegistration(Long dateOfRegistration) {
            this.dateOfRegistration = dateOfRegistration;
            return (B)this.self();
        }

        @JsonProperty(value="beneficiaryClientReferenceId")
        public B beneficiaryClientReferenceId(String beneficiaryClientReferenceId) {
            this.beneficiaryClientReferenceId = beneficiaryClientReferenceId;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @JsonProperty(value="tag")
        public B tag(String tag) {
            this.tag = tag;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ProjectBeneficiary.ProjectBeneficiaryBuilder(super=" + super.toString() + ", projectId=" + this.projectId + ", beneficiaryId=" + this.beneficiaryId + ", dateOfRegistration=" + this.dateOfRegistration + ", beneficiaryClientReferenceId=" + this.beneficiaryClientReferenceId + ", isDeleted=" + this.isDeleted + ", tag=" + this.tag + ")";
        }
    }

    private static final class ProjectBeneficiaryBuilderImpl
    extends ProjectBeneficiaryBuilder<ProjectBeneficiary, ProjectBeneficiaryBuilderImpl> {
        private ProjectBeneficiaryBuilderImpl() {
        }

        @Override
        protected ProjectBeneficiaryBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectBeneficiary build() {
            return new ProjectBeneficiary(this);
        }
    }
}

