/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovModel;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Product
extends EgovModel {
    @JsonProperty(value="type")
    @NotNull
    @Size(min=2, max=100)
    private @NotNull @Size(min=2, max=100) String type = null;
    @JsonProperty(value="name")
    @NotNull
    @Size(min=2, max=1000)
    private @NotNull @Size(min=2, max=1000) String name = null;
    @JsonProperty(value="manufacturer")
    @Size(min=0, max=1000)
    private @Size(min=0, max=1000) String manufacturer = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = null;

    protected Product(ProductBuilder<?, ?> b) {
        super(b);
        this.type = b.type;
        this.name = b.name;
        this.manufacturer = b.manufacturer;
        this.isDeleted = b.isDeleted;
    }

    public static ProductBuilder<?, ?> builder() {
        return new ProductBuilderImpl();
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getManufacturer() {
        return this.manufacturer;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="manufacturer")
    public void setManufacturer(String manufacturer) {
        this.manufacturer = manufacturer;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Product)) {
            return false;
        }
        Product other = (Product)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$manufacturer = this.getManufacturer();
        String other$manufacturer = other.getManufacturer();
        return !(this$manufacturer == null ? other$manufacturer != null : !this$manufacturer.equals(other$manufacturer));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Product;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $manufacturer = this.getManufacturer();
        result = result * 59 + ($manufacturer == null ? 43 : $manufacturer.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "Product(type=" + this.getType() + ", name=" + this.getName() + ", manufacturer=" + this.getManufacturer() + ", isDeleted=" + this.getIsDeleted() + ")";
    }

    public Product() {
    }

    public Product(String type, String name, String manufacturer, Boolean isDeleted) {
        this.type = type;
        this.name = name;
        this.manufacturer = manufacturer;
        this.isDeleted = isDeleted;
    }

    public static abstract class ProductBuilder<C extends Product, B extends ProductBuilder<C, B>>
    extends EgovModel.EgovModelBuilder<C, B> {
        private String type;
        private String name;
        private String manufacturer;
        private Boolean isDeleted;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="type")
        public B type(String type) {
            this.type = type;
            return (B)this.self();
        }

        @JsonProperty(value="name")
        public B name(String name) {
            this.name = name;
            return (B)this.self();
        }

        @JsonProperty(value="manufacturer")
        public B manufacturer(String manufacturer) {
            this.manufacturer = manufacturer;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "Product.ProductBuilder(super=" + super.toString() + ", type=" + this.type + ", name=" + this.name + ", manufacturer=" + this.manufacturer + ", isDeleted=" + this.isDeleted + ")";
        }
    }

    private static final class ProductBuilderImpl
    extends ProductBuilder<Product, ProductBuilderImpl> {
        private ProductBuilderImpl() {
        }

        @Override
        protected ProductBuilderImpl self() {
            return this;
        }

        @Override
        public Product build() {
            return new Product(this);
        }
    }
}

