/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.household.HouseholdMember;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdMemberBulkRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="HouseholdMembers")
    @NotNull
    @Valid
    @Size(min=1)
    private @NotNull @Valid @Size(min=1) List<HouseholdMember> householdMembers = new ArrayList<HouseholdMember>();

    public HouseholdMemberBulkRequest addHouseholdMemberItem(HouseholdMember householdMemberItem) {
        this.householdMembers.add(householdMemberItem);
        return this;
    }

    public static HouseholdMemberBulkRequestBuilder builder() {
        return new HouseholdMemberBulkRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<HouseholdMember> getHouseholdMembers() {
        return this.householdMembers;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="HouseholdMembers")
    public void setHouseholdMembers(List<HouseholdMember> householdMembers) {
        this.householdMembers = householdMembers;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdMemberBulkRequest)) {
            return false;
        }
        HouseholdMemberBulkRequest other = (HouseholdMemberBulkRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<HouseholdMember> this$householdMembers = this.getHouseholdMembers();
        List<HouseholdMember> other$householdMembers = other.getHouseholdMembers();
        return !(this$householdMembers == null ? other$householdMembers != null : !((Object)this$householdMembers).equals(other$householdMembers));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdMemberBulkRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<HouseholdMember> $householdMembers = this.getHouseholdMembers();
        result = result * 59 + ($householdMembers == null ? 43 : ((Object)$householdMembers).hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdMemberBulkRequest(requestInfo=" + this.getRequestInfo() + ", householdMembers=" + this.getHouseholdMembers() + ")";
    }

    public HouseholdMemberBulkRequest() {
    }

    public HouseholdMemberBulkRequest(RequestInfo requestInfo, List<HouseholdMember> householdMembers) {
        this.requestInfo = requestInfo;
        this.householdMembers = householdMembers;
    }

    public static class HouseholdMemberBulkRequestBuilder {
        private RequestInfo requestInfo;
        private List<HouseholdMember> householdMembers;

        HouseholdMemberBulkRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public HouseholdMemberBulkRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="HouseholdMembers")
        public HouseholdMemberBulkRequestBuilder householdMembers(List<HouseholdMember> householdMembers) {
            this.householdMembers = householdMembers;
            return this;
        }

        public HouseholdMemberBulkRequest build() {
            return new HouseholdMemberBulkRequest(this.requestInfo, this.householdMembers);
        }

        public String toString() {
            return "HouseholdMemberBulkRequest.HouseholdMemberBulkRequestBuilder(requestInfo=" + this.requestInfo + ", householdMembers=" + this.householdMembers + ")";
        }
    }
}

