/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.project.Task;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class TaskBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;
    @JsonProperty(value="Tasks")
    @NotNull
    @Valid
    private List<Task> tasks = null;

    public TaskBulkResponse addIndividualItem(Task taskItem) {
        if (this.tasks == null) {
            this.tasks = new ArrayList<Task>();
        }
        this.tasks.add(taskItem);
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static TaskBulkResponseBuilder builder() {
        return new TaskBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<Task> getTasks() {
        return this.tasks;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    @JsonProperty(value="Tasks")
    public void setTasks(List<Task> tasks) {
        this.tasks = tasks;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TaskBulkResponse)) {
            return false;
        }
        TaskBulkResponse other = (TaskBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Task> this$tasks = this.getTasks();
        List<Task> other$tasks = other.getTasks();
        return !(this$tasks == null ? other$tasks != null : !((Object)this$tasks).equals(other$tasks));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TaskBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Task> $tasks = this.getTasks();
        result = result * 59 + ($tasks == null ? 43 : ((Object)$tasks).hashCode());
        return result;
    }

    public String toString() {
        return "TaskBulkResponse(responseInfo=" + this.getResponseInfo() + ", totalCount=" + this.getTotalCount() + ", tasks=" + this.getTasks() + ")";
    }

    public TaskBulkResponse() {
        this.totalCount = TaskBulkResponse.$default$totalCount();
    }

    public TaskBulkResponse(ResponseInfo responseInfo, Long totalCount, List<Task> tasks) {
        this.responseInfo = responseInfo;
        this.totalCount = totalCount;
        this.tasks = tasks;
    }

    public static class TaskBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private boolean totalCount$set;
        private Long totalCount$value;
        private List<Task> tasks;

        TaskBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public TaskBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public TaskBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        @JsonProperty(value="Tasks")
        public TaskBulkResponseBuilder tasks(List<Task> tasks) {
            this.tasks = tasks;
            return this;
        }

        public TaskBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = TaskBulkResponse.$default$totalCount();
            }
            return new TaskBulkResponse(this.responseInfo, totalCount$value, this.tasks);
        }

        public String toString() {
            return "TaskBulkResponse.TaskBulkResponseBuilder(responseInfo=" + this.responseInfo + ", totalCount$value=" + this.totalCount$value + ", tasks=" + this.tasks + ")";
        }
    }
}

