/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.household;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.household.Household;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class HouseholdBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="Households")
    @Valid
    private List<Household> households = null;
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;

    public HouseholdBulkResponse addHouseholdItem(Household householdItem) {
        if (this.households == null) {
            this.households = new ArrayList<Household>();
        }
        this.households.add(householdItem);
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static HouseholdBulkResponseBuilder builder() {
        return new HouseholdBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<Household> getHouseholds() {
        return this.households;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="Households")
    public void setHouseholds(List<Household> households) {
        this.households = households;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HouseholdBulkResponse)) {
            return false;
        }
        HouseholdBulkResponse other = (HouseholdBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Household> this$households = this.getHouseholds();
        List<Household> other$households = other.getHouseholds();
        return !(this$households == null ? other$households != null : !((Object)this$households).equals(other$households));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HouseholdBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Household> $households = this.getHouseholds();
        result = result * 59 + ($households == null ? 43 : ((Object)$households).hashCode());
        return result;
    }

    public String toString() {
        return "HouseholdBulkResponse(responseInfo=" + this.getResponseInfo() + ", households=" + this.getHouseholds() + ", totalCount=" + this.getTotalCount() + ")";
    }

    public HouseholdBulkResponse() {
        this.totalCount = HouseholdBulkResponse.$default$totalCount();
    }

    public HouseholdBulkResponse(ResponseInfo responseInfo, List<Household> households, Long totalCount) {
        this.responseInfo = responseInfo;
        this.households = households;
        this.totalCount = totalCount;
    }

    public static class HouseholdBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<Household> households;
        private boolean totalCount$set;
        private Long totalCount$value;

        HouseholdBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public HouseholdBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="Households")
        public HouseholdBulkResponseBuilder households(List<Household> households) {
            this.households = households;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public HouseholdBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        public HouseholdBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = HouseholdBulkResponse.$default$totalCount();
            }
            return new HouseholdBulkResponse(this.responseInfo, this.households, totalCount$value);
        }

        public String toString() {
            return "HouseholdBulkResponse.HouseholdBulkResponseBuilder(responseInfo=" + this.responseInfo + ", households=" + this.households + ", totalCount$value=" + this.totalCount$value + ")";
        }
    }
}

