/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement.sideeffect;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.referralmanagement.sideeffect.SideEffect;

public class SideEffectBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo;
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;
    @JsonProperty(value="SideEffects")
    @NotNull
    @Valid
    private List<SideEffect> sideEffects = new ArrayList<SideEffect>();

    public SideEffectBulkResponse addSideEffectItem(SideEffect sideEffectItem) {
        if (Objects.isNull(this.sideEffects)) {
            this.sideEffects = new ArrayList<SideEffect>();
        }
        if (Objects.nonNull(sideEffectItem)) {
            this.sideEffects.add(sideEffectItem);
        }
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static SideEffectBulkResponseBuilder builder() {
        return new SideEffectBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<SideEffect> getSideEffects() {
        return this.sideEffects;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    @JsonProperty(value="SideEffects")
    public void setSideEffects(List<SideEffect> sideEffects) {
        this.sideEffects = sideEffects;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SideEffectBulkResponse)) {
            return false;
        }
        SideEffectBulkResponse other = (SideEffectBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<SideEffect> this$sideEffects = this.getSideEffects();
        List<SideEffect> other$sideEffects = other.getSideEffects();
        return !(this$sideEffects == null ? other$sideEffects != null : !((Object)this$sideEffects).equals(other$sideEffects));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SideEffectBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<SideEffect> $sideEffects = this.getSideEffects();
        result = result * 59 + ($sideEffects == null ? 43 : ((Object)$sideEffects).hashCode());
        return result;
    }

    public String toString() {
        return "SideEffectBulkResponse(responseInfo=" + this.getResponseInfo() + ", totalCount=" + this.getTotalCount() + ", sideEffects=" + this.getSideEffects() + ")";
    }

    public SideEffectBulkResponse() {
        this.totalCount = SideEffectBulkResponse.$default$totalCount();
    }

    public SideEffectBulkResponse(ResponseInfo responseInfo, Long totalCount, List<SideEffect> sideEffects) {
        this.responseInfo = responseInfo;
        this.totalCount = totalCount;
        this.sideEffects = sideEffects;
    }

    public static class SideEffectBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private boolean totalCount$set;
        private Long totalCount$value;
        private List<SideEffect> sideEffects;

        SideEffectBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public SideEffectBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public SideEffectBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        @JsonProperty(value="SideEffects")
        public SideEffectBulkResponseBuilder sideEffects(List<SideEffect> sideEffects) {
            this.sideEffects = sideEffects;
            return this;
        }

        public SideEffectBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = SideEffectBulkResponse.$default$totalCount();
            }
            return new SideEffectBulkResponse(this.responseInfo, totalCount$value, this.sideEffects);
        }

        public String toString() {
            return "SideEffectBulkResponse.SideEffectBulkResponseBuilder(responseInfo=" + this.responseInfo + ", totalCount$value=" + this.totalCount$value + ", sideEffects=" + this.sideEffects + ")";
        }
    }
}

