/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import org.egov.common.models.core.EgovModel;
import org.egov.common.models.project.ProjectProductVariant;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="This object defines the mapping of a resource to a project.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectResource
extends EgovModel {
    @JsonProperty(value="projectId")
    @NotNull
    @Size(min=2, max=64)
    private @NotNull @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="resource")
    @NotNull
    private ProjectProductVariant resource = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="startDate")
    private Long startDate = null;
    @JsonProperty(value="endDate")
    private Long endDate = null;

    protected ProjectResource(ProjectResourceBuilder<?, ?> b) {
        super(b);
        this.projectId = b.projectId;
        this.resource = b.resource;
        this.isDeleted = b.isDeleted;
        this.startDate = b.startDate;
        this.endDate = b.endDate;
    }

    public static ProjectResourceBuilder<?, ?> builder() {
        return new ProjectResourceBuilderImpl();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public ProjectProductVariant getResource() {
        return this.resource;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="resource")
    public void setResource(ProjectProductVariant resource) {
        this.resource = resource;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectResource)) {
            return false;
        }
        ProjectResource other = (ProjectResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Long this$startDate = this.getStartDate();
        Long other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Long this$endDate = this.getEndDate();
        Long other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        ProjectProductVariant this$resource = this.getResource();
        ProjectProductVariant other$resource = other.getResource();
        return !(this$resource == null ? other$resource != null : !((Object)this$resource).equals(other$resource));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ProjectResource;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Long $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Long $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        ProjectProductVariant $resource = this.getResource();
        result = result * 59 + ($resource == null ? 43 : ((Object)$resource).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "ProjectResource(projectId=" + this.getProjectId() + ", resource=" + this.getResource() + ", isDeleted=" + this.getIsDeleted() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ")";
    }

    public ProjectResource() {
    }

    public ProjectResource(String projectId, ProjectProductVariant resource, Boolean isDeleted, Long startDate, Long endDate) {
        this.projectId = projectId;
        this.resource = resource;
        this.isDeleted = isDeleted;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public static abstract class ProjectResourceBuilder<C extends ProjectResource, B extends ProjectResourceBuilder<C, B>>
    extends EgovModel.EgovModelBuilder<C, B> {
        private String projectId;
        private ProjectProductVariant resource;
        private Boolean isDeleted;
        private Long startDate;
        private Long endDate;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="projectId")
        public B projectId(String projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        @JsonProperty(value="resource")
        public B resource(ProjectProductVariant resource) {
            this.resource = resource;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return (B)this.self();
        }

        @JsonProperty(value="startDate")
        public B startDate(Long startDate) {
            this.startDate = startDate;
            return (B)this.self();
        }

        @JsonProperty(value="endDate")
        public B endDate(Long endDate) {
            this.endDate = endDate;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ProjectResource.ProjectResourceBuilder(super=" + super.toString() + ", projectId=" + this.projectId + ", resource=" + this.resource + ", isDeleted=" + this.isDeleted + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ")";
        }
    }

    private static final class ProjectResourceBuilderImpl
    extends ProjectResourceBuilder<ProjectResource, ProjectResourceBuilderImpl> {
        private ProjectResourceBuilderImpl() {
        }

        @Override
        protected ProjectResourceBuilderImpl self() {
            return this;
        }

        @Override
        public ProjectResource build() {
            return new ProjectResource(this);
        }
    }
}

