/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.project.ProjectStaff;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectStaffBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo = null;
    @JsonProperty(value="ProjectStaff")
    @NotNull
    @Valid
    private List<ProjectStaff> projectStaff = new ArrayList<ProjectStaff>();

    public ProjectStaffBulkResponse addProjectStaffItem(ProjectStaff projectStaffItem) {
        this.projectStaff.add(projectStaffItem);
        return this;
    }

    public static ProjectStaffBulkResponseBuilder builder() {
        return new ProjectStaffBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public List<ProjectStaff> getProjectStaff() {
        return this.projectStaff;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="ProjectStaff")
    public void setProjectStaff(List<ProjectStaff> projectStaff) {
        this.projectStaff = projectStaff;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectStaffBulkResponse)) {
            return false;
        }
        ProjectStaffBulkResponse other = (ProjectStaffBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<ProjectStaff> this$projectStaff = this.getProjectStaff();
        List<ProjectStaff> other$projectStaff = other.getProjectStaff();
        return !(this$projectStaff == null ? other$projectStaff != null : !((Object)this$projectStaff).equals(other$projectStaff));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectStaffBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<ProjectStaff> $projectStaff = this.getProjectStaff();
        result = result * 59 + ($projectStaff == null ? 43 : ((Object)$projectStaff).hashCode());
        return result;
    }

    public String toString() {
        return "ProjectStaffBulkResponse(responseInfo=" + this.getResponseInfo() + ", projectStaff=" + this.getProjectStaff() + ")";
    }

    public ProjectStaffBulkResponse() {
    }

    public ProjectStaffBulkResponse(ResponseInfo responseInfo, List<ProjectStaff> projectStaff) {
        this.responseInfo = responseInfo;
        this.projectStaff = projectStaff;
    }

    public static class ProjectStaffBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private List<ProjectStaff> projectStaff;

        ProjectStaffBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ProjectStaffBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="ProjectStaff")
        public ProjectStaffBulkResponseBuilder projectStaff(List<ProjectStaff> projectStaff) {
            this.projectStaff = projectStaff;
            return this;
        }

        public ProjectStaffBulkResponse build() {
            return new ProjectStaffBulkResponse(this.responseInfo, this.projectStaff);
        }

        public String toString() {
            return "ProjectStaffBulkResponse.ProjectStaffBulkResponseBuilder(responseInfo=" + this.responseInfo + ", projectStaff=" + this.projectStaff + ")";
        }
    }
}

