/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.referralmanagement;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.models.referralmanagement.Referral;

public class ReferralBulkResponse {
    @JsonProperty(value="ResponseInfo")
    @NotNull
    @Valid
    private ResponseInfo responseInfo;
    @JsonProperty(value="TotalCount")
    @Valid
    private Long totalCount;
    @JsonProperty(value="Referrals")
    @NotNull
    @Valid
    private List<Referral> referrals;

    public ReferralBulkResponse addReferralItem(Referral referralItem) {
        if (Objects.isNull(this.referrals)) {
            this.referrals = new ArrayList<Referral>();
        }
        if (Objects.nonNull(referralItem)) {
            this.referrals.add(referralItem);
        }
        return this;
    }

    private static Long $default$totalCount() {
        return 0L;
    }

    public static ReferralBulkResponseBuilder builder() {
        return new ReferralBulkResponseBuilder();
    }

    public ResponseInfo getResponseInfo() {
        return this.responseInfo;
    }

    public Long getTotalCount() {
        return this.totalCount;
    }

    public List<Referral> getReferrals() {
        return this.referrals;
    }

    @JsonProperty(value="ResponseInfo")
    public void setResponseInfo(ResponseInfo responseInfo) {
        this.responseInfo = responseInfo;
    }

    @JsonProperty(value="TotalCount")
    public void setTotalCount(Long totalCount) {
        this.totalCount = totalCount;
    }

    @JsonProperty(value="Referrals")
    public void setReferrals(List<Referral> referrals) {
        this.referrals = referrals;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReferralBulkResponse)) {
            return false;
        }
        ReferralBulkResponse other = (ReferralBulkResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$totalCount = this.getTotalCount();
        Long other$totalCount = other.getTotalCount();
        if (this$totalCount == null ? other$totalCount != null : !((Object)this$totalCount).equals(other$totalCount)) {
            return false;
        }
        ResponseInfo this$responseInfo = this.getResponseInfo();
        ResponseInfo other$responseInfo = other.getResponseInfo();
        if (this$responseInfo == null ? other$responseInfo != null : !this$responseInfo.equals(other$responseInfo)) {
            return false;
        }
        List<Referral> this$referrals = this.getReferrals();
        List<Referral> other$referrals = other.getReferrals();
        return !(this$referrals == null ? other$referrals != null : !((Object)this$referrals).equals(other$referrals));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReferralBulkResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $totalCount = this.getTotalCount();
        result = result * 59 + ($totalCount == null ? 43 : ((Object)$totalCount).hashCode());
        ResponseInfo $responseInfo = this.getResponseInfo();
        result = result * 59 + ($responseInfo == null ? 43 : $responseInfo.hashCode());
        List<Referral> $referrals = this.getReferrals();
        result = result * 59 + ($referrals == null ? 43 : ((Object)$referrals).hashCode());
        return result;
    }

    public String toString() {
        return "ReferralBulkResponse(responseInfo=" + this.getResponseInfo() + ", totalCount=" + this.getTotalCount() + ", referrals=" + this.getReferrals() + ")";
    }

    public ReferralBulkResponse() {
        this.totalCount = ReferralBulkResponse.$default$totalCount();
    }

    public ReferralBulkResponse(ResponseInfo responseInfo, Long totalCount, List<Referral> referrals) {
        this.responseInfo = responseInfo;
        this.totalCount = totalCount;
        this.referrals = referrals;
    }

    public static class ReferralBulkResponseBuilder {
        private ResponseInfo responseInfo;
        private boolean totalCount$set;
        private Long totalCount$value;
        private List<Referral> referrals;

        ReferralBulkResponseBuilder() {
        }

        @JsonProperty(value="ResponseInfo")
        public ReferralBulkResponseBuilder responseInfo(ResponseInfo responseInfo) {
            this.responseInfo = responseInfo;
            return this;
        }

        @JsonProperty(value="TotalCount")
        public ReferralBulkResponseBuilder totalCount(Long totalCount) {
            this.totalCount$value = totalCount;
            this.totalCount$set = true;
            return this;
        }

        @JsonProperty(value="Referrals")
        public ReferralBulkResponseBuilder referrals(List<Referral> referrals) {
            this.referrals = referrals;
            return this;
        }

        public ReferralBulkResponse build() {
            Long totalCount$value = this.totalCount$value;
            if (!this.totalCount$set) {
                totalCount$value = ReferralBulkResponse.$default$totalCount();
            }
            return new ReferralBulkResponse(this.responseInfo, totalCount$value, this.referrals);
        }

        public String toString() {
            return "ReferralBulkResponse.ReferralBulkResponseBuilder(responseInfo=" + this.responseInfo + ", totalCount$value=" + this.totalCount$value + ", referrals=" + this.referrals + ")";
        }
    }
}

