/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.product;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.util.ArrayList;
import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.models.product.ApiOperation;
import org.egov.common.models.product.Product;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProductRequest {
    @JsonProperty(value="RequestInfo")
    @NotNull
    @Valid
    private RequestInfo requestInfo = null;
    @JsonProperty(value="Product")
    @NotNull
    @Size(min=1)
    @Valid
    private @NotNull @Size(min=1) @Valid List<Product> product = new ArrayList<Product>();
    @JsonProperty(value="apiOperation")
    @Valid
    private ApiOperation apiOperation = null;

    public ProductRequest addProductItem(Product productItem) {
        this.product.add(productItem);
        return this;
    }

    public static ProductRequestBuilder builder() {
        return new ProductRequestBuilder();
    }

    public RequestInfo getRequestInfo() {
        return this.requestInfo;
    }

    public List<Product> getProduct() {
        return this.product;
    }

    public ApiOperation getApiOperation() {
        return this.apiOperation;
    }

    @JsonProperty(value="RequestInfo")
    public void setRequestInfo(RequestInfo requestInfo) {
        this.requestInfo = requestInfo;
    }

    @JsonProperty(value="Product")
    public void setProduct(List<Product> product) {
        this.product = product;
    }

    @JsonProperty(value="apiOperation")
    public void setApiOperation(ApiOperation apiOperation) {
        this.apiOperation = apiOperation;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProductRequest)) {
            return false;
        }
        ProductRequest other = (ProductRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        RequestInfo this$requestInfo = this.getRequestInfo();
        RequestInfo other$requestInfo = other.getRequestInfo();
        if (this$requestInfo == null ? other$requestInfo != null : !this$requestInfo.equals(other$requestInfo)) {
            return false;
        }
        List<Product> this$product = this.getProduct();
        List<Product> other$product = other.getProduct();
        if (this$product == null ? other$product != null : !((Object)this$product).equals(other$product)) {
            return false;
        }
        ApiOperation this$apiOperation = this.getApiOperation();
        ApiOperation other$apiOperation = other.getApiOperation();
        return !(this$apiOperation == null ? other$apiOperation != null : !((Object)((Object)this$apiOperation)).equals((Object)other$apiOperation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProductRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        RequestInfo $requestInfo = this.getRequestInfo();
        result = result * 59 + ($requestInfo == null ? 43 : $requestInfo.hashCode());
        List<Product> $product = this.getProduct();
        result = result * 59 + ($product == null ? 43 : ((Object)$product).hashCode());
        ApiOperation $apiOperation = this.getApiOperation();
        result = result * 59 + ($apiOperation == null ? 43 : ((Object)((Object)$apiOperation)).hashCode());
        return result;
    }

    public String toString() {
        return "ProductRequest(requestInfo=" + this.getRequestInfo() + ", product=" + this.getProduct() + ", apiOperation=" + this.getApiOperation() + ")";
    }

    public ProductRequest() {
    }

    public ProductRequest(RequestInfo requestInfo, List<Product> product, ApiOperation apiOperation) {
        this.requestInfo = requestInfo;
        this.product = product;
        this.apiOperation = apiOperation;
    }

    public static class ProductRequestBuilder {
        private RequestInfo requestInfo;
        private List<Product> product;
        private ApiOperation apiOperation;

        ProductRequestBuilder() {
        }

        @JsonProperty(value="RequestInfo")
        public ProductRequestBuilder requestInfo(RequestInfo requestInfo) {
            this.requestInfo = requestInfo;
            return this;
        }

        @JsonProperty(value="Product")
        public ProductRequestBuilder product(List<Product> product) {
            this.product = product;
            return this;
        }

        @JsonProperty(value="apiOperation")
        public ProductRequestBuilder apiOperation(ApiOperation apiOperation) {
            this.apiOperation = apiOperation;
            return this;
        }

        public ProductRequest build() {
            return new ProductRequest(this.requestInfo, this.product, this.apiOperation);
        }

        public String toString() {
            return "ProductRequest.ProductRequestBuilder(requestInfo=" + this.requestInfo + ", product=" + this.product + ", apiOperation=" + this.apiOperation + ")";
        }
    }
}

