/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import java.util.List;
import javax.validation.constraints.Size;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="This object defines the mapping of a system staff user to a project for a certain period.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class ProjectStaffSearch {
    @JsonProperty(value="id")
    private List<String> id = null;
    @JsonProperty(value="tenantId")
    @Size(min=2, max=1000)
    private @Size(min=2, max=1000) String tenantId = null;
    @JsonProperty(value="staffId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) List<String> staffId = null;
    @JsonProperty(value="projectId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String projectId = null;
    @JsonProperty(value="startDate")
    private Long startDate = null;
    @JsonProperty(value="endDate")
    private Long endDate = null;

    public static ProjectStaffSearchBuilder builder() {
        return new ProjectStaffSearchBuilder();
    }

    public List<String> getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public List<String> getStaffId() {
        return this.staffId;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    @JsonProperty(value="id")
    public void setId(List<String> id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="staffId")
    public void setStaffId(List<String> staffId) {
        this.staffId = staffId;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProjectStaffSearch)) {
            return false;
        }
        ProjectStaffSearch other = (ProjectStaffSearch)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$startDate = this.getStartDate();
        Long other$startDate = other.getStartDate();
        if (this$startDate == null ? other$startDate != null : !((Object)this$startDate).equals(other$startDate)) {
            return false;
        }
        Long this$endDate = this.getEndDate();
        Long other$endDate = other.getEndDate();
        if (this$endDate == null ? other$endDate != null : !((Object)this$endDate).equals(other$endDate)) {
            return false;
        }
        List<String> this$id = this.getId();
        List<String> other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        List<String> this$staffId = this.getStaffId();
        List<String> other$staffId = other.getStaffId();
        if (this$staffId == null ? other$staffId != null : !((Object)this$staffId).equals(other$staffId)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        return !(this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProjectStaffSearch;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $startDate = this.getStartDate();
        result = result * 59 + ($startDate == null ? 43 : ((Object)$startDate).hashCode());
        Long $endDate = this.getEndDate();
        result = result * 59 + ($endDate == null ? 43 : ((Object)$endDate).hashCode());
        List<String> $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        List<String> $staffId = this.getStaffId();
        result = result * 59 + ($staffId == null ? 43 : ((Object)$staffId).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        return result;
    }

    public String toString() {
        return "ProjectStaffSearch(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", staffId=" + this.getStaffId() + ", projectId=" + this.getProjectId() + ", startDate=" + this.getStartDate() + ", endDate=" + this.getEndDate() + ")";
    }

    public ProjectStaffSearch() {
    }

    public ProjectStaffSearch(List<String> id, String tenantId, List<String> staffId, String projectId, Long startDate, Long endDate) {
        this.id = id;
        this.tenantId = tenantId;
        this.staffId = staffId;
        this.projectId = projectId;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    public static class ProjectStaffSearchBuilder {
        private List<String> id;
        private String tenantId;
        private List<String> staffId;
        private String projectId;
        private Long startDate;
        private Long endDate;

        ProjectStaffSearchBuilder() {
        }

        @JsonProperty(value="id")
        public ProjectStaffSearchBuilder id(List<String> id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ProjectStaffSearchBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="staffId")
        public ProjectStaffSearchBuilder staffId(List<String> staffId) {
            this.staffId = staffId;
            return this;
        }

        @JsonProperty(value="projectId")
        public ProjectStaffSearchBuilder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        @JsonProperty(value="startDate")
        public ProjectStaffSearchBuilder startDate(Long startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="endDate")
        public ProjectStaffSearchBuilder endDate(Long endDate) {
            this.endDate = endDate;
            return this;
        }

        public ProjectStaffSearch build() {
            return new ProjectStaffSearch(this.id, this.tenantId, this.staffId, this.projectId, this.startDate, this.endDate);
        }

        public String toString() {
            return "ProjectStaffSearch.ProjectStaffSearchBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", staffId=" + this.staffId + ", projectId=" + this.projectId + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ")";
        }
    }
}

