/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import io.swagger.annotations.ApiModel;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.egov.common.models.project.Address;
import org.egov.common.models.project.Document;
import org.egov.common.models.project.Target;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="The purpose of this object to define the Project for a geography and period")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Project {
    @JsonProperty(value="id")
    private String id = null;
    @JsonProperty(value="tenantId")
    private String tenantId = null;
    @JsonProperty(value="projectNumber")
    private String projectNumber = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="projectType")
    private String projectType = null;
    @JsonProperty(value="projectSubType")
    private String projectSubType = null;
    @JsonProperty(value="department")
    private String department = null;
    @JsonProperty(value="description")
    private String description = null;
    @JsonProperty(value="referenceID")
    private String referenceID = null;
    @JsonProperty(value="projectTypeId")
    private String projectTypeId = null;
    @JsonProperty(value="documents")
    @Valid
    private List<Document> documents = null;
    @JsonProperty(value="address")
    private Address address = null;
    @JsonProperty(value="startDate")
    private Long startDate = null;
    @JsonProperty(value="endDate")
    private Long endDate = null;
    @JsonProperty(value="isTaskEnabled")
    private Boolean isTaskEnabled = false;
    @JsonProperty(value="parent")
    private String parent = null;
    @JsonProperty(value="projectHierarchy")
    private String projectHierarchy = null;
    @JsonProperty(value="natureOfWork")
    private String natureOfWork = null;
    @JsonProperty(value="ancestors")
    private List<Project> ancestors = null;
    @JsonProperty(value="descendants")
    private List<Project> descendants = null;
    @JsonProperty(value="targets")
    @Valid
    private List<Target> targets = null;
    @JsonProperty(value="additionalDetails")
    private Object additionalDetails = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = false;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails = null;

    public Project addDocumentsItem(Document documentsItem) {
        if (this.documents == null) {
            this.documents = new ArrayList<Document>();
        }
        this.documents.add(documentsItem);
        return this;
    }

    public Project addTargetsItem(Target targetsItem) {
        if (this.targets == null) {
            this.targets = new ArrayList<Target>();
        }
        this.targets.add(targetsItem);
        return this;
    }

    public Project addDescendant(Project project) {
        if (this.descendants == null) {
            this.descendants = new ArrayList<Project>();
        }
        this.descendants.add(project);
        return this;
    }

    public static ProjectBuilder builder() {
        return new ProjectBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getProjectNumber() {
        return this.projectNumber;
    }

    public String getName() {
        return this.name;
    }

    public String getProjectType() {
        return this.projectType;
    }

    public String getProjectSubType() {
        return this.projectSubType;
    }

    public String getDepartment() {
        return this.department;
    }

    public String getDescription() {
        return this.description;
    }

    public String getReferenceID() {
        return this.referenceID;
    }

    public String getProjectTypeId() {
        return this.projectTypeId;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public Address getAddress() {
        return this.address;
    }

    public Long getStartDate() {
        return this.startDate;
    }

    public Long getEndDate() {
        return this.endDate;
    }

    public Boolean getIsTaskEnabled() {
        return this.isTaskEnabled;
    }

    public String getParent() {
        return this.parent;
    }

    public String getProjectHierarchy() {
        return this.projectHierarchy;
    }

    public String getNatureOfWork() {
        return this.natureOfWork;
    }

    public List<Project> getAncestors() {
        return this.ancestors;
    }

    public List<Project> getDescendants() {
        return this.descendants;
    }

    public List<Target> getTargets() {
        return this.targets;
    }

    public Object getAdditionalDetails() {
        return this.additionalDetails;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="projectNumber")
    public void setProjectNumber(String projectNumber) {
        this.projectNumber = projectNumber;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="projectType")
    public void setProjectType(String projectType) {
        this.projectType = projectType;
    }

    @JsonProperty(value="projectSubType")
    public void setProjectSubType(String projectSubType) {
        this.projectSubType = projectSubType;
    }

    @JsonProperty(value="department")
    public void setDepartment(String department) {
        this.department = department;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="referenceID")
    public void setReferenceID(String referenceID) {
        this.referenceID = referenceID;
    }

    @JsonProperty(value="projectTypeId")
    public void setProjectTypeId(String projectTypeId) {
        this.projectTypeId = projectTypeId;
    }

    @JsonProperty(value="documents")
    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    @JsonProperty(value="address")
    public void setAddress(Address address) {
        this.address = address;
    }

    @JsonProperty(value="startDate")
    public void setStartDate(Long startDate) {
        this.startDate = startDate;
    }

    @JsonProperty(value="endDate")
    public void setEndDate(Long endDate) {
        this.endDate = endDate;
    }

    @JsonProperty(value="isTaskEnabled")
    public void setIsTaskEnabled(Boolean isTaskEnabled) {
        this.isTaskEnabled = isTaskEnabled;
    }

    @JsonProperty(value="parent")
    public void setParent(String parent) {
        this.parent = parent;
    }

    @JsonProperty(value="projectHierarchy")
    public void setProjectHierarchy(String projectHierarchy) {
        this.projectHierarchy = projectHierarchy;
    }

    @JsonProperty(value="natureOfWork")
    public void setNatureOfWork(String natureOfWork) {
        this.natureOfWork = natureOfWork;
    }

    @JsonProperty(value="ancestors")
    public void setAncestors(List<Project> ancestors) {
        this.ancestors = ancestors;
    }

    @JsonProperty(value="descendants")
    public void setDescendants(List<Project> descendants) {
        this.descendants = descendants;
    }

    @JsonProperty(value="targets")
    public void setTargets(List<Target> targets) {
        this.targets = targets;
    }

    @JsonProperty(value="additionalDetails")
    public void setAdditionalDetails(Object additionalDetails) {
        this.additionalDetails = additionalDetails;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public Project(String id, String tenantId, String projectNumber, String name, String projectType, String projectSubType, String department, String description, String referenceID, String projectTypeId, List<Document> documents, Address address, Long startDate, Long endDate, Boolean isTaskEnabled, String parent, String projectHierarchy, String natureOfWork, List<Project> ancestors, List<Project> descendants, List<Target> targets, Object additionalDetails, Boolean isDeleted, Integer rowVersion, AuditDetails auditDetails) {
        this.id = id;
        this.tenantId = tenantId;
        this.projectNumber = projectNumber;
        this.name = name;
        this.projectType = projectType;
        this.projectSubType = projectSubType;
        this.department = department;
        this.description = description;
        this.referenceID = referenceID;
        this.projectTypeId = projectTypeId;
        this.documents = documents;
        this.address = address;
        this.startDate = startDate;
        this.endDate = endDate;
        this.isTaskEnabled = isTaskEnabled;
        this.parent = parent;
        this.projectHierarchy = projectHierarchy;
        this.natureOfWork = natureOfWork;
        this.ancestors = ancestors;
        this.descendants = descendants;
        this.targets = targets;
        this.additionalDetails = additionalDetails;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.auditDetails = auditDetails;
    }

    public Project() {
    }

    public static class ProjectBuilder {
        private String id;
        private String tenantId;
        private String projectNumber;
        private String name;
        private String projectType;
        private String projectSubType;
        private String department;
        private String description;
        private String referenceID;
        private String projectTypeId;
        private List<Document> documents;
        private Address address;
        private Long startDate;
        private Long endDate;
        private Boolean isTaskEnabled;
        private String parent;
        private String projectHierarchy;
        private String natureOfWork;
        private List<Project> ancestors;
        private List<Project> descendants;
        private List<Target> targets;
        private Object additionalDetails;
        private Boolean isDeleted;
        private Integer rowVersion;
        private AuditDetails auditDetails;

        ProjectBuilder() {
        }

        @JsonProperty(value="id")
        public ProjectBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public ProjectBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="projectNumber")
        public ProjectBuilder projectNumber(String projectNumber) {
            this.projectNumber = projectNumber;
            return this;
        }

        @JsonProperty(value="name")
        public ProjectBuilder name(String name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="projectType")
        public ProjectBuilder projectType(String projectType) {
            this.projectType = projectType;
            return this;
        }

        @JsonProperty(value="projectSubType")
        public ProjectBuilder projectSubType(String projectSubType) {
            this.projectSubType = projectSubType;
            return this;
        }

        @JsonProperty(value="department")
        public ProjectBuilder department(String department) {
            this.department = department;
            return this;
        }

        @JsonProperty(value="description")
        public ProjectBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="referenceID")
        public ProjectBuilder referenceID(String referenceID) {
            this.referenceID = referenceID;
            return this;
        }

        @JsonProperty(value="projectTypeId")
        public ProjectBuilder projectTypeId(String projectTypeId) {
            this.projectTypeId = projectTypeId;
            return this;
        }

        @JsonProperty(value="documents")
        public ProjectBuilder documents(List<Document> documents) {
            this.documents = documents;
            return this;
        }

        @JsonProperty(value="address")
        public ProjectBuilder address(Address address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="startDate")
        public ProjectBuilder startDate(Long startDate) {
            this.startDate = startDate;
            return this;
        }

        @JsonProperty(value="endDate")
        public ProjectBuilder endDate(Long endDate) {
            this.endDate = endDate;
            return this;
        }

        @JsonProperty(value="isTaskEnabled")
        public ProjectBuilder isTaskEnabled(Boolean isTaskEnabled) {
            this.isTaskEnabled = isTaskEnabled;
            return this;
        }

        @JsonProperty(value="parent")
        public ProjectBuilder parent(String parent) {
            this.parent = parent;
            return this;
        }

        @JsonProperty(value="projectHierarchy")
        public ProjectBuilder projectHierarchy(String projectHierarchy) {
            this.projectHierarchy = projectHierarchy;
            return this;
        }

        @JsonProperty(value="natureOfWork")
        public ProjectBuilder natureOfWork(String natureOfWork) {
            this.natureOfWork = natureOfWork;
            return this;
        }

        @JsonProperty(value="ancestors")
        public ProjectBuilder ancestors(List<Project> ancestors) {
            this.ancestors = ancestors;
            return this;
        }

        @JsonProperty(value="descendants")
        public ProjectBuilder descendants(List<Project> descendants) {
            this.descendants = descendants;
            return this;
        }

        @JsonProperty(value="targets")
        public ProjectBuilder targets(List<Target> targets) {
            this.targets = targets;
            return this;
        }

        @JsonProperty(value="additionalDetails")
        public ProjectBuilder additionalDetails(Object additionalDetails) {
            this.additionalDetails = additionalDetails;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public ProjectBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public ProjectBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public ProjectBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        public Project build() {
            return new Project(this.id, this.tenantId, this.projectNumber, this.name, this.projectType, this.projectSubType, this.department, this.description, this.referenceID, this.projectTypeId, this.documents, this.address, this.startDate, this.endDate, this.isTaskEnabled, this.parent, this.projectHierarchy, this.natureOfWork, this.ancestors, this.descendants, this.targets, this.additionalDetails, this.isDeleted, this.rowVersion, this.auditDetails);
        }

        public String toString() {
            return "Project.ProjectBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", projectNumber=" + this.projectNumber + ", name=" + this.name + ", projectType=" + this.projectType + ", projectSubType=" + this.projectSubType + ", department=" + this.department + ", description=" + this.description + ", referenceID=" + this.referenceID + ", projectTypeId=" + this.projectTypeId + ", documents=" + this.documents + ", address=" + this.address + ", startDate=" + this.startDate + ", endDate=" + this.endDate + ", isTaskEnabled=" + this.isTaskEnabled + ", parent=" + this.parent + ", projectHierarchy=" + this.projectHierarchy + ", natureOfWork=" + this.natureOfWork + ", ancestors=" + this.ancestors + ", descendants=" + this.descendants + ", targets=" + this.targets + ", additionalDetails=" + this.additionalDetails + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", auditDetails=" + this.auditDetails + ")";
        }
    }
}

