/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.project.useraction;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.validation.constraints.DecimalMax;
import javax.validation.constraints.DecimalMin;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.core.EgovOfflineModel;
import org.egov.common.models.project.UserActionEnum;
import org.springframework.validation.annotation.Validated;

@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class UserAction
extends EgovOfflineModel {
    @JsonProperty(value="projectId")
    @Size(min=2, max=64, message="Project ID must be between 2 and 64 characters")
    @NotNull
    private @Size(min=2, max=64, message="Project ID must be between 2 and 64 characters") @NotNull String projectId;
    @JsonProperty(value="latitude")
    @DecimalMin(value="-90")
    @DecimalMax(value="90")
    @NotNull
    private @DecimalMin(value="-90") @DecimalMax(value="90") @NotNull Double latitude;
    @JsonProperty(value="longitude")
    @DecimalMin(value="-180")
    @DecimalMax(value="180")
    @NotNull
    private @DecimalMin(value="-180") @DecimalMax(value="180") @NotNull Double longitude;
    @JsonProperty(value="locationAccuracy")
    @DecimalMin(value="0")
    @NotNull
    private @DecimalMin(value="0") @NotNull Double locationAccuracy;
    @JsonProperty(value="boundaryCode")
    @NotNull
    private String boundaryCode;
    @JsonProperty(value="action")
    @NotNull
    private UserActionEnum action;
    @JsonProperty(value="beneficiaryTag")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String beneficiaryTag;
    @JsonProperty(value="resourceTag")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String resourceTag;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted;

    private static Boolean $default$isDeleted() {
        return false;
    }

    protected UserAction(UserActionBuilder<?, ?> b) {
        super((EgovOfflineModel.EgovOfflineModelBuilder<?, ?>)b);
        this.projectId = ((UserActionBuilder)b).projectId;
        this.latitude = ((UserActionBuilder)b).latitude;
        this.longitude = ((UserActionBuilder)b).longitude;
        this.locationAccuracy = ((UserActionBuilder)b).locationAccuracy;
        this.boundaryCode = ((UserActionBuilder)b).boundaryCode;
        this.action = ((UserActionBuilder)b).action;
        this.beneficiaryTag = ((UserActionBuilder)b).beneficiaryTag;
        this.resourceTag = ((UserActionBuilder)b).resourceTag;
        this.isDeleted = ((UserActionBuilder)b).isDeleted$set ? ((UserActionBuilder)b).isDeleted$value : UserAction.$default$isDeleted();
    }

    public static UserActionBuilder<?, ?> builder() {
        return new UserActionBuilderImpl();
    }

    public String getProjectId() {
        return this.projectId;
    }

    public Double getLatitude() {
        return this.latitude;
    }

    public Double getLongitude() {
        return this.longitude;
    }

    public Double getLocationAccuracy() {
        return this.locationAccuracy;
    }

    public String getBoundaryCode() {
        return this.boundaryCode;
    }

    public UserActionEnum getAction() {
        return this.action;
    }

    public String getBeneficiaryTag() {
        return this.beneficiaryTag;
    }

    public String getResourceTag() {
        return this.resourceTag;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    @JsonProperty(value="projectId")
    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    @JsonProperty(value="latitude")
    public void setLatitude(Double latitude) {
        this.latitude = latitude;
    }

    @JsonProperty(value="longitude")
    public void setLongitude(Double longitude) {
        this.longitude = longitude;
    }

    @JsonProperty(value="locationAccuracy")
    public void setLocationAccuracy(Double locationAccuracy) {
        this.locationAccuracy = locationAccuracy;
    }

    @JsonProperty(value="boundaryCode")
    public void setBoundaryCode(String boundaryCode) {
        this.boundaryCode = boundaryCode;
    }

    @JsonProperty(value="action")
    public void setAction(UserActionEnum action) {
        this.action = action;
    }

    @JsonProperty(value="beneficiaryTag")
    public void setBeneficiaryTag(String beneficiaryTag) {
        this.beneficiaryTag = beneficiaryTag;
    }

    @JsonProperty(value="resourceTag")
    public void setResourceTag(String resourceTag) {
        this.resourceTag = resourceTag;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserAction)) {
            return false;
        }
        UserAction other = (UserAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$latitude = this.getLatitude();
        Double other$latitude = other.getLatitude();
        if (this$latitude == null ? other$latitude != null : !((Object)this$latitude).equals(other$latitude)) {
            return false;
        }
        Double this$longitude = this.getLongitude();
        Double other$longitude = other.getLongitude();
        if (this$longitude == null ? other$longitude != null : !((Object)this$longitude).equals(other$longitude)) {
            return false;
        }
        Double this$locationAccuracy = this.getLocationAccuracy();
        Double other$locationAccuracy = other.getLocationAccuracy();
        if (this$locationAccuracy == null ? other$locationAccuracy != null : !((Object)this$locationAccuracy).equals(other$locationAccuracy)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        String this$projectId = this.getProjectId();
        String other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !this$projectId.equals(other$projectId)) {
            return false;
        }
        String this$boundaryCode = this.getBoundaryCode();
        String other$boundaryCode = other.getBoundaryCode();
        if (this$boundaryCode == null ? other$boundaryCode != null : !this$boundaryCode.equals(other$boundaryCode)) {
            return false;
        }
        UserActionEnum this$action = this.getAction();
        UserActionEnum other$action = other.getAction();
        if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
            return false;
        }
        String this$beneficiaryTag = this.getBeneficiaryTag();
        String other$beneficiaryTag = other.getBeneficiaryTag();
        if (this$beneficiaryTag == null ? other$beneficiaryTag != null : !this$beneficiaryTag.equals(other$beneficiaryTag)) {
            return false;
        }
        String this$resourceTag = this.getResourceTag();
        String other$resourceTag = other.getResourceTag();
        return !(this$resourceTag == null ? other$resourceTag != null : !this$resourceTag.equals(other$resourceTag));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof UserAction;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $latitude = this.getLatitude();
        result = result * 59 + ($latitude == null ? 43 : ((Object)$latitude).hashCode());
        Double $longitude = this.getLongitude();
        result = result * 59 + ($longitude == null ? 43 : ((Object)$longitude).hashCode());
        Double $locationAccuracy = this.getLocationAccuracy();
        result = result * 59 + ($locationAccuracy == null ? 43 : ((Object)$locationAccuracy).hashCode());
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        String $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : $projectId.hashCode());
        String $boundaryCode = this.getBoundaryCode();
        result = result * 59 + ($boundaryCode == null ? 43 : $boundaryCode.hashCode());
        UserActionEnum $action = this.getAction();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        String $beneficiaryTag = this.getBeneficiaryTag();
        result = result * 59 + ($beneficiaryTag == null ? 43 : $beneficiaryTag.hashCode());
        String $resourceTag = this.getResourceTag();
        result = result * 59 + ($resourceTag == null ? 43 : $resourceTag.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "UserAction(projectId=" + this.getProjectId() + ", latitude=" + this.getLatitude() + ", longitude=" + this.getLongitude() + ", locationAccuracy=" + this.getLocationAccuracy() + ", boundaryCode=" + this.getBoundaryCode() + ", action=" + (Object)((Object)this.getAction()) + ", beneficiaryTag=" + this.getBeneficiaryTag() + ", resourceTag=" + this.getResourceTag() + ", isDeleted=" + this.getIsDeleted() + ")";
    }

    public UserAction() {
        this.isDeleted = UserAction.$default$isDeleted();
    }

    public UserAction(String projectId, Double latitude, Double longitude, Double locationAccuracy, String boundaryCode, UserActionEnum action, String beneficiaryTag, String resourceTag, Boolean isDeleted) {
        this.projectId = projectId;
        this.latitude = latitude;
        this.longitude = longitude;
        this.locationAccuracy = locationAccuracy;
        this.boundaryCode = boundaryCode;
        this.action = action;
        this.beneficiaryTag = beneficiaryTag;
        this.resourceTag = resourceTag;
        this.isDeleted = isDeleted;
    }

    private static final class UserActionBuilderImpl
    extends UserActionBuilder<UserAction, UserActionBuilderImpl> {
        private UserActionBuilderImpl() {
        }

        @Override
        protected UserActionBuilderImpl self() {
            return this;
        }

        @Override
        public UserAction build() {
            return new UserAction(this);
        }
    }

    public static abstract class UserActionBuilder<C extends UserAction, B extends UserActionBuilder<C, B>>
    extends EgovOfflineModel.EgovOfflineModelBuilder<C, B> {
        private String projectId;
        private Double latitude;
        private Double longitude;
        private Double locationAccuracy;
        private String boundaryCode;
        private UserActionEnum action;
        private String beneficiaryTag;
        private String resourceTag;
        private boolean isDeleted$set;
        private Boolean isDeleted$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        @JsonProperty(value="projectId")
        public B projectId(String projectId) {
            this.projectId = projectId;
            return (B)this.self();
        }

        @JsonProperty(value="latitude")
        public B latitude(Double latitude) {
            this.latitude = latitude;
            return (B)this.self();
        }

        @JsonProperty(value="longitude")
        public B longitude(Double longitude) {
            this.longitude = longitude;
            return (B)this.self();
        }

        @JsonProperty(value="locationAccuracy")
        public B locationAccuracy(Double locationAccuracy) {
            this.locationAccuracy = locationAccuracy;
            return (B)this.self();
        }

        @JsonProperty(value="boundaryCode")
        public B boundaryCode(String boundaryCode) {
            this.boundaryCode = boundaryCode;
            return (B)this.self();
        }

        @JsonProperty(value="action")
        public B action(UserActionEnum action) {
            this.action = action;
            return (B)this.self();
        }

        @JsonProperty(value="beneficiaryTag")
        public B beneficiaryTag(String beneficiaryTag) {
            this.beneficiaryTag = beneficiaryTag;
            return (B)this.self();
        }

        @JsonProperty(value="resourceTag")
        public B resourceTag(String resourceTag) {
            this.resourceTag = resourceTag;
            return (B)this.self();
        }

        @JsonProperty(value="isDeleted")
        public B isDeleted(Boolean isDeleted) {
            this.isDeleted$value = isDeleted;
            this.isDeleted$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "UserAction.UserActionBuilder(super=" + super.toString() + ", projectId=" + this.projectId + ", latitude=" + this.latitude + ", longitude=" + this.longitude + ", locationAccuracy=" + this.locationAccuracy + ", boundaryCode=" + this.boundaryCode + ", action=" + (Object)((Object)this.action) + ", beneficiaryTag=" + this.beneficiaryTag + ", resourceTag=" + this.resourceTag + ", isDeleted$value=" + this.isDeleted$value + ")";
        }
    }
}

