/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.models.individual;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import digit.models.coremodels.AuditDetails;
import io.swagger.annotations.ApiModel;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.common.models.individual.AdditionalFields;
import org.egov.common.models.individual.Address;
import org.egov.common.models.individual.BloodGroup;
import org.egov.common.models.individual.Gender;
import org.egov.common.models.individual.Identifier;
import org.egov.common.models.individual.Name;
import org.egov.common.models.individual.Skill;
import org.springframework.validation.annotation.Validated;

@ApiModel(description="A representation of an Individual.")
@Validated
@JsonIgnoreProperties(ignoreUnknown=true)
public class Individual {
    @JsonProperty(value="id")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=2, max=1000)
    private @NotNull @Size(min=2, max=1000) String tenantId = null;
    @JsonProperty(value="clientReferenceId")
    @Size(min=2, max=64)
    private @Size(min=2, max=64) String clientReferenceId = null;
    @JsonProperty(value="userId")
    private String userId = null;
    @JsonProperty(value="name")
    @NotNull
    @Valid
    private Name name = null;
    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    private LocalDate dateOfBirth = null;
    @JsonProperty(value="gender")
    @Valid
    private Gender gender = null;
    @JsonProperty(value="bloodGroup")
    @Valid
    private BloodGroup bloodGroup = null;
    @JsonProperty(value="mobileNumber")
    @Size(max=20)
    private @Size(max=20) String mobileNumber = null;
    @JsonProperty(value="altContactNumber")
    @Size(max=16)
    private @Size(max=16) String altContactNumber = null;
    @JsonProperty(value="email")
    @Size(min=5, max=200)
    private @Size(min=5, max=200) String email = null;
    @JsonProperty(value="address")
    @Valid
    @Size(max=3)
    private @Valid @Size(max=3) List<Address> address = null;
    @JsonProperty(value="fatherName")
    @Size(max=100)
    private @Size(max=100) String fatherName = null;
    @JsonProperty(value="husbandName")
    @Size(max=100)
    private @Size(max=100) String husbandName = null;
    @JsonProperty(value="identifiers")
    @Valid
    private List<Identifier> identifiers = null;
    @JsonProperty(value="skills")
    @Valid
    private List<Skill> skills = null;
    @JsonProperty(value="photo")
    private String photo = null;
    @JsonProperty(value="additionalFields")
    @Valid
    private AdditionalFields additionalFields = null;
    @JsonProperty(value="isDeleted")
    private Boolean isDeleted = Boolean.FALSE;
    @JsonProperty(value="rowVersion")
    private Integer rowVersion = null;
    @JsonProperty(value="auditDetails")
    @Valid
    private AuditDetails auditDetails = null;
    @JsonIgnore
    private Boolean hasErrors = Boolean.FALSE;

    public Individual addAddressItem(Address addressItem) {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(addressItem);
        return this;
    }

    public Individual addIdentifiersItem(Identifier identifiersItem) {
        if (this.identifiers == null) {
            this.identifiers = new ArrayList<Identifier>();
        }
        this.identifiers.add(identifiersItem);
        return this;
    }

    public Individual addSkillsItem(Skill skillItem) {
        if (this.skills == null) {
            this.skills = new ArrayList<Skill>();
        }
        this.skills.add(skillItem);
        return this;
    }

    public static IndividualBuilder builder() {
        return new IndividualBuilder();
    }

    public String getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getClientReferenceId() {
        return this.clientReferenceId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Name getName() {
        return this.name;
    }

    public LocalDate getDateOfBirth() {
        return this.dateOfBirth;
    }

    public Gender getGender() {
        return this.gender;
    }

    public BloodGroup getBloodGroup() {
        return this.bloodGroup;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public String getAltContactNumber() {
        return this.altContactNumber;
    }

    public String getEmail() {
        return this.email;
    }

    public List<Address> getAddress() {
        return this.address;
    }

    public String getFatherName() {
        return this.fatherName;
    }

    public String getHusbandName() {
        return this.husbandName;
    }

    public List<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public List<Skill> getSkills() {
        return this.skills;
    }

    public String getPhoto() {
        return this.photo;
    }

    public AdditionalFields getAdditionalFields() {
        return this.additionalFields;
    }

    public Boolean getIsDeleted() {
        return this.isDeleted;
    }

    public Integer getRowVersion() {
        return this.rowVersion;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public Boolean getHasErrors() {
        return this.hasErrors;
    }

    @JsonProperty(value="id")
    public void setId(String id) {
        this.id = id;
    }

    @JsonProperty(value="tenantId")
    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    @JsonProperty(value="clientReferenceId")
    public void setClientReferenceId(String clientReferenceId) {
        this.clientReferenceId = clientReferenceId;
    }

    @JsonProperty(value="userId")
    public void setUserId(String userId) {
        this.userId = userId;
    }

    @JsonProperty(value="name")
    public void setName(Name name) {
        this.name = name;
    }

    @JsonProperty(value="dateOfBirth")
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
    public void setDateOfBirth(LocalDate dateOfBirth) {
        this.dateOfBirth = dateOfBirth;
    }

    @JsonProperty(value="gender")
    public void setGender(Gender gender) {
        this.gender = gender;
    }

    @JsonProperty(value="bloodGroup")
    public void setBloodGroup(BloodGroup bloodGroup) {
        this.bloodGroup = bloodGroup;
    }

    @JsonProperty(value="mobileNumber")
    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    @JsonProperty(value="altContactNumber")
    public void setAltContactNumber(String altContactNumber) {
        this.altContactNumber = altContactNumber;
    }

    @JsonProperty(value="email")
    public void setEmail(String email) {
        this.email = email;
    }

    @JsonProperty(value="address")
    public void setAddress(List<Address> address) {
        this.address = address;
    }

    @JsonProperty(value="fatherName")
    public void setFatherName(String fatherName) {
        this.fatherName = fatherName;
    }

    @JsonProperty(value="husbandName")
    public void setHusbandName(String husbandName) {
        this.husbandName = husbandName;
    }

    @JsonProperty(value="identifiers")
    public void setIdentifiers(List<Identifier> identifiers) {
        this.identifiers = identifiers;
    }

    @JsonProperty(value="skills")
    public void setSkills(List<Skill> skills) {
        this.skills = skills;
    }

    @JsonProperty(value="photo")
    public void setPhoto(String photo) {
        this.photo = photo;
    }

    @JsonProperty(value="additionalFields")
    public void setAdditionalFields(AdditionalFields additionalFields) {
        this.additionalFields = additionalFields;
    }

    @JsonProperty(value="isDeleted")
    public void setIsDeleted(Boolean isDeleted) {
        this.isDeleted = isDeleted;
    }

    @JsonProperty(value="rowVersion")
    public void setRowVersion(Integer rowVersion) {
        this.rowVersion = rowVersion;
    }

    @JsonProperty(value="auditDetails")
    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    @JsonIgnore
    public void setHasErrors(Boolean hasErrors) {
        this.hasErrors = hasErrors;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Individual)) {
            return false;
        }
        Individual other = (Individual)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isDeleted = this.getIsDeleted();
        Boolean other$isDeleted = other.getIsDeleted();
        if (this$isDeleted == null ? other$isDeleted != null : !((Object)this$isDeleted).equals(other$isDeleted)) {
            return false;
        }
        Integer this$rowVersion = this.getRowVersion();
        Integer other$rowVersion = other.getRowVersion();
        if (this$rowVersion == null ? other$rowVersion != null : !((Object)this$rowVersion).equals(other$rowVersion)) {
            return false;
        }
        Boolean this$hasErrors = this.getHasErrors();
        Boolean other$hasErrors = other.getHasErrors();
        if (this$hasErrors == null ? other$hasErrors != null : !((Object)this$hasErrors).equals(other$hasErrors)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$tenantId = this.getTenantId();
        String other$tenantId = other.getTenantId();
        if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
            return false;
        }
        String this$clientReferenceId = this.getClientReferenceId();
        String other$clientReferenceId = other.getClientReferenceId();
        if (this$clientReferenceId == null ? other$clientReferenceId != null : !this$clientReferenceId.equals(other$clientReferenceId)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        Name this$name = this.getName();
        Name other$name = other.getName();
        if (this$name == null ? other$name != null : !((Object)this$name).equals(other$name)) {
            return false;
        }
        LocalDate this$dateOfBirth = this.getDateOfBirth();
        LocalDate other$dateOfBirth = other.getDateOfBirth();
        if (this$dateOfBirth == null ? other$dateOfBirth != null : !((Object)this$dateOfBirth).equals(other$dateOfBirth)) {
            return false;
        }
        Gender this$gender = this.getGender();
        Gender other$gender = other.getGender();
        if (this$gender == null ? other$gender != null : !((Object)((Object)this$gender)).equals((Object)other$gender)) {
            return false;
        }
        BloodGroup this$bloodGroup = this.getBloodGroup();
        BloodGroup other$bloodGroup = other.getBloodGroup();
        if (this$bloodGroup == null ? other$bloodGroup != null : !((Object)((Object)this$bloodGroup)).equals((Object)other$bloodGroup)) {
            return false;
        }
        String this$mobileNumber = this.getMobileNumber();
        String other$mobileNumber = other.getMobileNumber();
        if (this$mobileNumber == null ? other$mobileNumber != null : !this$mobileNumber.equals(other$mobileNumber)) {
            return false;
        }
        String this$altContactNumber = this.getAltContactNumber();
        String other$altContactNumber = other.getAltContactNumber();
        if (this$altContactNumber == null ? other$altContactNumber != null : !this$altContactNumber.equals(other$altContactNumber)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        List<Address> this$address = this.getAddress();
        List<Address> other$address = other.getAddress();
        if (this$address == null ? other$address != null : !((Object)this$address).equals(other$address)) {
            return false;
        }
        String this$fatherName = this.getFatherName();
        String other$fatherName = other.getFatherName();
        if (this$fatherName == null ? other$fatherName != null : !this$fatherName.equals(other$fatherName)) {
            return false;
        }
        String this$husbandName = this.getHusbandName();
        String other$husbandName = other.getHusbandName();
        if (this$husbandName == null ? other$husbandName != null : !this$husbandName.equals(other$husbandName)) {
            return false;
        }
        List<Identifier> this$identifiers = this.getIdentifiers();
        List<Identifier> other$identifiers = other.getIdentifiers();
        if (this$identifiers == null ? other$identifiers != null : !((Object)this$identifiers).equals(other$identifiers)) {
            return false;
        }
        List<Skill> this$skills = this.getSkills();
        List<Skill> other$skills = other.getSkills();
        if (this$skills == null ? other$skills != null : !((Object)this$skills).equals(other$skills)) {
            return false;
        }
        String this$photo = this.getPhoto();
        String other$photo = other.getPhoto();
        if (this$photo == null ? other$photo != null : !this$photo.equals(other$photo)) {
            return false;
        }
        AdditionalFields this$additionalFields = this.getAdditionalFields();
        AdditionalFields other$additionalFields = other.getAdditionalFields();
        if (this$additionalFields == null ? other$additionalFields != null : !((Object)this$additionalFields).equals(other$additionalFields)) {
            return false;
        }
        AuditDetails this$auditDetails = this.getAuditDetails();
        AuditDetails other$auditDetails = other.getAuditDetails();
        return !(this$auditDetails == null ? other$auditDetails != null : !this$auditDetails.equals(other$auditDetails));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Individual;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isDeleted = this.getIsDeleted();
        result = result * 59 + ($isDeleted == null ? 43 : ((Object)$isDeleted).hashCode());
        Integer $rowVersion = this.getRowVersion();
        result = result * 59 + ($rowVersion == null ? 43 : ((Object)$rowVersion).hashCode());
        Boolean $hasErrors = this.getHasErrors();
        result = result * 59 + ($hasErrors == null ? 43 : ((Object)$hasErrors).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $tenantId = this.getTenantId();
        result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
        String $clientReferenceId = this.getClientReferenceId();
        result = result * 59 + ($clientReferenceId == null ? 43 : $clientReferenceId.hashCode());
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        Name $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        LocalDate $dateOfBirth = this.getDateOfBirth();
        result = result * 59 + ($dateOfBirth == null ? 43 : ((Object)$dateOfBirth).hashCode());
        Gender $gender = this.getGender();
        result = result * 59 + ($gender == null ? 43 : ((Object)((Object)$gender)).hashCode());
        BloodGroup $bloodGroup = this.getBloodGroup();
        result = result * 59 + ($bloodGroup == null ? 43 : ((Object)((Object)$bloodGroup)).hashCode());
        String $mobileNumber = this.getMobileNumber();
        result = result * 59 + ($mobileNumber == null ? 43 : $mobileNumber.hashCode());
        String $altContactNumber = this.getAltContactNumber();
        result = result * 59 + ($altContactNumber == null ? 43 : $altContactNumber.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        List<Address> $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : ((Object)$address).hashCode());
        String $fatherName = this.getFatherName();
        result = result * 59 + ($fatherName == null ? 43 : $fatherName.hashCode());
        String $husbandName = this.getHusbandName();
        result = result * 59 + ($husbandName == null ? 43 : $husbandName.hashCode());
        List<Identifier> $identifiers = this.getIdentifiers();
        result = result * 59 + ($identifiers == null ? 43 : ((Object)$identifiers).hashCode());
        List<Skill> $skills = this.getSkills();
        result = result * 59 + ($skills == null ? 43 : ((Object)$skills).hashCode());
        String $photo = this.getPhoto();
        result = result * 59 + ($photo == null ? 43 : $photo.hashCode());
        AdditionalFields $additionalFields = this.getAdditionalFields();
        result = result * 59 + ($additionalFields == null ? 43 : ((Object)$additionalFields).hashCode());
        AuditDetails $auditDetails = this.getAuditDetails();
        result = result * 59 + ($auditDetails == null ? 43 : $auditDetails.hashCode());
        return result;
    }

    public String toString() {
        return "Individual(id=" + this.getId() + ", tenantId=" + this.getTenantId() + ", clientReferenceId=" + this.getClientReferenceId() + ", userId=" + this.getUserId() + ", name=" + this.getName() + ", dateOfBirth=" + this.getDateOfBirth() + ", gender=" + (Object)((Object)this.getGender()) + ", bloodGroup=" + (Object)((Object)this.getBloodGroup()) + ", mobileNumber=" + this.getMobileNumber() + ", altContactNumber=" + this.getAltContactNumber() + ", email=" + this.getEmail() + ", address=" + this.getAddress() + ", fatherName=" + this.getFatherName() + ", husbandName=" + this.getHusbandName() + ", identifiers=" + this.getIdentifiers() + ", skills=" + this.getSkills() + ", photo=" + this.getPhoto() + ", additionalFields=" + this.getAdditionalFields() + ", isDeleted=" + this.getIsDeleted() + ", rowVersion=" + this.getRowVersion() + ", auditDetails=" + this.getAuditDetails() + ", hasErrors=" + this.getHasErrors() + ")";
    }

    public Individual() {
    }

    public Individual(String id, String tenantId, String clientReferenceId, String userId, Name name, LocalDate dateOfBirth, Gender gender, BloodGroup bloodGroup, String mobileNumber, String altContactNumber, String email, List<Address> address, String fatherName, String husbandName, List<Identifier> identifiers, List<Skill> skills, String photo, AdditionalFields additionalFields, Boolean isDeleted, Integer rowVersion, AuditDetails auditDetails, Boolean hasErrors) {
        this.id = id;
        this.tenantId = tenantId;
        this.clientReferenceId = clientReferenceId;
        this.userId = userId;
        this.name = name;
        this.dateOfBirth = dateOfBirth;
        this.gender = gender;
        this.bloodGroup = bloodGroup;
        this.mobileNumber = mobileNumber;
        this.altContactNumber = altContactNumber;
        this.email = email;
        this.address = address;
        this.fatherName = fatherName;
        this.husbandName = husbandName;
        this.identifiers = identifiers;
        this.skills = skills;
        this.photo = photo;
        this.additionalFields = additionalFields;
        this.isDeleted = isDeleted;
        this.rowVersion = rowVersion;
        this.auditDetails = auditDetails;
        this.hasErrors = hasErrors;
    }

    public static class IndividualBuilder {
        private String id;
        private String tenantId;
        private String clientReferenceId;
        private String userId;
        private Name name;
        private LocalDate dateOfBirth;
        private Gender gender;
        private BloodGroup bloodGroup;
        private String mobileNumber;
        private String altContactNumber;
        private String email;
        private List<Address> address;
        private String fatherName;
        private String husbandName;
        private List<Identifier> identifiers;
        private List<Skill> skills;
        private String photo;
        private AdditionalFields additionalFields;
        private Boolean isDeleted;
        private Integer rowVersion;
        private AuditDetails auditDetails;
        private Boolean hasErrors;

        IndividualBuilder() {
        }

        @JsonProperty(value="id")
        public IndividualBuilder id(String id) {
            this.id = id;
            return this;
        }

        @JsonProperty(value="tenantId")
        public IndividualBuilder tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        @JsonProperty(value="clientReferenceId")
        public IndividualBuilder clientReferenceId(String clientReferenceId) {
            this.clientReferenceId = clientReferenceId;
            return this;
        }

        @JsonProperty(value="userId")
        public IndividualBuilder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="name")
        public IndividualBuilder name(Name name) {
            this.name = name;
            return this;
        }

        @JsonProperty(value="dateOfBirth")
        @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="dd/MM/yyyy")
        public IndividualBuilder dateOfBirth(LocalDate dateOfBirth) {
            this.dateOfBirth = dateOfBirth;
            return this;
        }

        @JsonProperty(value="gender")
        public IndividualBuilder gender(Gender gender) {
            this.gender = gender;
            return this;
        }

        @JsonProperty(value="bloodGroup")
        public IndividualBuilder bloodGroup(BloodGroup bloodGroup) {
            this.bloodGroup = bloodGroup;
            return this;
        }

        @JsonProperty(value="mobileNumber")
        public IndividualBuilder mobileNumber(String mobileNumber) {
            this.mobileNumber = mobileNumber;
            return this;
        }

        @JsonProperty(value="altContactNumber")
        public IndividualBuilder altContactNumber(String altContactNumber) {
            this.altContactNumber = altContactNumber;
            return this;
        }

        @JsonProperty(value="email")
        public IndividualBuilder email(String email) {
            this.email = email;
            return this;
        }

        @JsonProperty(value="address")
        public IndividualBuilder address(List<Address> address) {
            this.address = address;
            return this;
        }

        @JsonProperty(value="fatherName")
        public IndividualBuilder fatherName(String fatherName) {
            this.fatherName = fatherName;
            return this;
        }

        @JsonProperty(value="husbandName")
        public IndividualBuilder husbandName(String husbandName) {
            this.husbandName = husbandName;
            return this;
        }

        @JsonProperty(value="identifiers")
        public IndividualBuilder identifiers(List<Identifier> identifiers) {
            this.identifiers = identifiers;
            return this;
        }

        @JsonProperty(value="skills")
        public IndividualBuilder skills(List<Skill> skills) {
            this.skills = skills;
            return this;
        }

        @JsonProperty(value="photo")
        public IndividualBuilder photo(String photo) {
            this.photo = photo;
            return this;
        }

        @JsonProperty(value="additionalFields")
        public IndividualBuilder additionalFields(AdditionalFields additionalFields) {
            this.additionalFields = additionalFields;
            return this;
        }

        @JsonProperty(value="isDeleted")
        public IndividualBuilder isDeleted(Boolean isDeleted) {
            this.isDeleted = isDeleted;
            return this;
        }

        @JsonProperty(value="rowVersion")
        public IndividualBuilder rowVersion(Integer rowVersion) {
            this.rowVersion = rowVersion;
            return this;
        }

        @JsonProperty(value="auditDetails")
        public IndividualBuilder auditDetails(AuditDetails auditDetails) {
            this.auditDetails = auditDetails;
            return this;
        }

        @JsonIgnore
        public IndividualBuilder hasErrors(Boolean hasErrors) {
            this.hasErrors = hasErrors;
            return this;
        }

        public Individual build() {
            return new Individual(this.id, this.tenantId, this.clientReferenceId, this.userId, this.name, this.dateOfBirth, this.gender, this.bloodGroup, this.mobileNumber, this.altContactNumber, this.email, this.address, this.fatherName, this.husbandName, this.identifiers, this.skills, this.photo, this.additionalFields, this.isDeleted, this.rowVersion, this.auditDetails, this.hasErrors);
        }

        public String toString() {
            return "Individual.IndividualBuilder(id=" + this.id + ", tenantId=" + this.tenantId + ", clientReferenceId=" + this.clientReferenceId + ", userId=" + this.userId + ", name=" + this.name + ", dateOfBirth=" + this.dateOfBirth + ", gender=" + (Object)((Object)this.gender) + ", bloodGroup=" + (Object)((Object)this.bloodGroup) + ", mobileNumber=" + this.mobileNumber + ", altContactNumber=" + this.altContactNumber + ", email=" + this.email + ", address=" + this.address + ", fatherName=" + this.fatherName + ", husbandName=" + this.husbandName + ", identifiers=" + this.identifiers + ", skills=" + this.skills + ", photo=" + this.photo + ", additionalFields=" + this.additionalFields + ", isDeleted=" + this.isDeleted + ", rowVersion=" + this.rowVersion + ", auditDetails=" + this.auditDetails + ", hasErrors=" + this.hasErrors + ")";
        }
    }
}

