/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.service;

import org.egov.common.http.client.ServiceRequestClient;
import org.egov.common.models.abha.AbhaGatewayOtpVerifyRequest;
import org.egov.common.models.abha.AbhaGatewayOtpVerifyResponse;
import org.egov.common.models.abha.AbhaOtpRequest;
import org.egov.common.models.abha.AbhaOtpResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnProperty(name={"egov.abha.integration.enabled"}, havingValue="true")
public class AbhaService {
    private static final Logger log = LoggerFactory.getLogger(AbhaService.class);
    private final String abhaHost;
    private final String sendOtpPath;
    private final String verifyOtpPath;
    private final ServiceRequestClient serviceRequestClient;

    @Autowired
    public AbhaService(ServiceRequestClient serviceRequestClient, @Value(value="${egov.abha.host}") String abhaHost, @Value(value="${egov.abha.send.otp.path:/api/abha/create/send-aadhaar-otp}") String sendOtpPath, @Value(value="${egov.abha.verify.otp.path:/api/abha/create/verify-and-enroll-with-aadhaar-otp}") String verifyOtpPath) {
        this.abhaHost = abhaHost;
        this.sendOtpPath = sendOtpPath;
        this.verifyOtpPath = verifyOtpPath;
        this.serviceRequestClient = serviceRequestClient;
    }

    public AbhaOtpResponse sendAadhaarOtp(AbhaOtpRequest request) {
        String uri = this.abhaHost + this.sendOtpPath;
        return this.serviceRequestClient.fetchResult(new StringBuilder(uri), request, AbhaOtpResponse.class);
    }

    public AbhaGatewayOtpVerifyResponse verifyAadhaarOtp(AbhaGatewayOtpVerifyRequest request) {
        String uri = this.abhaHost + this.verifyOtpPath;
        return this.serviceRequestClient.fetchResult(new StringBuilder(uri), request, AbhaGatewayOtpVerifyResponse.class);
    }
}

