/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.data.repository;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.egov.common.data.query.builder.SelectQueryBuilder;
import org.egov.common.data.query.exception.QueryBuilderException;
import org.egov.common.exception.InvalidTenantIdException;
import org.egov.common.models.core.SearchResponse;
import org.egov.common.producer.Producer;
import org.egov.common.utils.CommonUtils;
import org.egov.common.utils.MultiStateInstanceUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

public abstract class GenericRepository<T> {
    private static final Logger log = LoggerFactory.getLogger(GenericRepository.class);
    protected final NamedParameterJdbcTemplate namedParameterJdbcTemplate;
    protected final Producer producer;
    protected final RedisTemplate<String, Object> redisTemplate;
    protected final SelectQueryBuilder selectQueryBuilder;
    protected final RowMapper<T> rowMapper;
    @Autowired
    protected MultiStateInstanceUtil multiStateInstanceUtil;
    protected String tableName;
    @Value(value="${spring.cache.redis.time-to-live:60}")
    private String timeToLive;

    protected GenericRepository(Producer producer, NamedParameterJdbcTemplate namedParameterJdbcTemplate, RedisTemplate<String, Object> redisTemplate, SelectQueryBuilder selectQueryBuilder, RowMapper<T> rowMapper, Optional<String> tableName) {
        this.producer = producer;
        this.namedParameterJdbcTemplate = namedParameterJdbcTemplate;
        this.redisTemplate = redisTemplate;
        this.selectQueryBuilder = selectQueryBuilder;
        this.rowMapper = rowMapper;
        tableName.ifPresent(tb -> {
            this.tableName = tb;
        });
    }

    public List<T> findById(String tenantId, List<String> ids) throws InvalidTenantIdException {
        return this.findById(tenantId, ids, false);
    }

    protected List<T> findInCache(String tenantId, List<String> ids) {
        List objFromCache;
        ArrayList objFound = new ArrayList();
        Collection collection = ids.stream().filter(Objects::nonNull).collect(Collectors.toList());
        log.info("Searching in cache");
        String cacheTableName = this.tableName;
        String schemaName = CommonUtils.getSchemaName(tenantId, this.multiStateInstanceUtil);
        if (!ObjectUtils.isEmpty((Object)schemaName)) {
            cacheTableName = schemaName.concat("-").concat(cacheTableName);
        }
        if (!(objFromCache = this.redisTemplate.opsForHash().multiGet((Object)cacheTableName, collection).stream().filter(Objects::nonNull).collect(Collectors.toList())).isEmpty()) {
            if (objFromCache.size() == 1 && objFromCache.contains(null)) {
                log.info("Cache miss");
            } else {
                log.info("Cache hit, {} items found", (Object)objFromCache.size());
                objFound = (ArrayList)objFromCache.stream().map(Object.class::cast).collect(Collectors.toList());
            }
        } else {
            log.info("Cache miss");
        }
        return objFound;
    }

    public List<T> findById(String tenantId, List<String> ids, Boolean includeDeleted) throws InvalidTenantIdException {
        return this.findById(tenantId, ids, includeDeleted, "id");
    }

    public List<T> findById(String tenantId, List<String> ids, Boolean includeDeleted, String columnName) throws InvalidTenantIdException {
        List<T> objFound = this.findInCache(tenantId, ids);
        if (!objFound.isEmpty()) {
            Method idMethod = CommonUtils.getIdMethod(objFound, columnName);
            Method isDeleted = CommonUtils.getMethod("getIsDeleted", CommonUtils.getObjClass(objFound));
            if (!includeDeleted.booleanValue()) {
                objFound = objFound.stream().filter(entity -> Objects.equals(ReflectionUtils.invokeMethod((Method)isDeleted, (Object)entity), false)).collect(Collectors.toList());
            }
            ids.removeAll(objFound.stream().map(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toList()));
            if (ids.isEmpty()) {
                return objFound;
            }
        }
        String query = String.format("SELECT * FROM %s.%s WHERE %s IN (:ids) AND isDeleted = false", MultiStateInstanceUtil.SCHEMA_REPLACE_STRING, this.tableName, columnName);
        if (null != includeDeleted && includeDeleted.booleanValue()) {
            query = String.format("SELECT * FROM %s.%s WHERE %s IN (:ids)", MultiStateInstanceUtil.SCHEMA_REPLACE_STRING, this.tableName, columnName);
        }
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("ids", ids);
        query = this.multiStateInstanceUtil.replaceSchemaPlaceholder(query, tenantId);
        objFound.addAll(this.namedParameterJdbcTemplate.query(query, paramMap, this.rowMapper));
        this.putInCache(objFound);
        return objFound;
    }

    public List<T> save(List<T> objects, String topic) {
        String tenantId = CommonUtils.getTenantId(objects);
        this.producer.push(tenantId, topic, objects);
        log.info("Pushed to kafka");
        this.putInCache(objects);
        log.info("Saved to cache");
        return objects;
    }

    public List<T> save(List<T> objects, String topic, String cacheKey) {
        String tenantId = CommonUtils.getTenantId(objects);
        this.producer.push(tenantId, topic, objects);
        log.info("Pushed to kafka");
        this.putInCache(objects, cacheKey);
        log.info("Saved to cache");
        return objects;
    }

    protected void cacheByKey(List<T> objects, String fieldName) {
        try {
            Method getIdMethod = CommonUtils.getIdMethod(objects, fieldName);
            if (ReflectionUtils.invokeMethod((Method)getIdMethod, objects.stream().findAny().get()) != null) {
                Map<String, Object> objMap = objects.stream().collect(Collectors.toMap(obj -> {
                    String str = (String)ReflectionUtils.invokeMethod((Method)getIdMethod, (Object)obj);
                    log.info("Caching the {}: {}", (Object)getIdMethod.getName(), (Object)str);
                    return str;
                }, obj -> obj, (obj1, obj2) -> obj2));
                String cacheTableName = this.tableName;
                String tenantId = CommonUtils.getTenantId(objects);
                String schemaName = CommonUtils.getSchemaName(tenantId, this.multiStateInstanceUtil);
                if (!ObjectUtils.isEmpty((Object)schemaName)) {
                    cacheTableName = schemaName.concat("-").concat(cacheTableName);
                }
                this.redisTemplate.opsForHash().putAll((Object)cacheTableName, objMap);
                this.redisTemplate.expire((Object)cacheTableName, Long.parseLong(this.timeToLive), TimeUnit.SECONDS);
            }
        }
        catch (Exception exception) {
            log.warn("Error while saving to cache: {}", (Object)ExceptionUtils.getStackTrace((Throwable)exception));
        }
    }

    public void putInCache(List<T> objects) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        this.cacheByKey(objects, "clientReferenceId");
    }

    public void putInCache(List<T> objects, String key) {
        if (objects == null || objects.isEmpty()) {
            return;
        }
        this.cacheByKey(objects, key);
    }

    public SearchResponse<T> findWithCount(Object searchObject, Integer limit, Integer offset, String tenantId, Long lastChangedSince, Boolean includeDeleted) throws QueryBuilderException, InvalidTenantIdException {
        Object query = this.selectQueryBuilder.build(searchObject, this.tableName, MultiStateInstanceUtil.SCHEMA_REPLACE_STRING);
        if (((String)(query = (String)query + " AND tenantId=:tenantId ")).contains(this.tableName + " AND")) {
            query = ((String)query).replace(this.tableName + " AND", this.tableName + " WHERE");
        }
        if (Boolean.FALSE.equals(includeDeleted)) {
            query = (String)query + "AND isDeleted=:isDeleted ";
        }
        if (lastChangedSince != null) {
            query = (String)query + "AND lastModifiedTime>=:lastModifiedTime ";
        }
        query = (String)query + "ORDER BY id ASC";
        Map<String, Object> paramsMap = this.selectQueryBuilder.getParamsMap();
        paramsMap.put("tenantId", tenantId);
        paramsMap.put("isDeleted", includeDeleted);
        paramsMap.put("lastModifiedTime", lastChangedSince);
        query = this.multiStateInstanceUtil.replaceSchemaPlaceholder((String)query, tenantId);
        Long totalCount = CommonUtils.constructTotalCountCTEAndReturnResult((String)query, paramsMap, this.namedParameterJdbcTemplate);
        query = (String)query + " LIMIT :limit OFFSET :offset";
        paramsMap.put("limit", limit);
        paramsMap.put("offset", offset);
        List resultantList = this.namedParameterJdbcTemplate.query((String)query, paramsMap, this.rowMapper);
        return SearchResponse.builder().response(resultantList).totalCount(totalCount).build();
    }

    public List<T> find(Object searchObject, Integer limit, Integer offset, String tenantId, Long lastChangedSince, Boolean includeDeleted) throws QueryBuilderException, InvalidTenantIdException {
        Object query = this.selectQueryBuilder.build(searchObject, this.tableName, MultiStateInstanceUtil.SCHEMA_REPLACE_STRING);
        if (((String)(query = (String)query + " AND tenantId=:tenantId ")).contains(this.tableName + " AND")) {
            query = ((String)query).replace(this.tableName + " AND", this.tableName + " WHERE");
        }
        if (Boolean.FALSE.equals(includeDeleted)) {
            query = (String)query + "AND isDeleted=:isDeleted ";
        }
        if (lastChangedSince != null) {
            query = (String)query + "AND lastModifiedTime>=:lastModifiedTime ";
        }
        query = (String)query + "ORDER BY id ASC LIMIT :limit OFFSET :offset";
        Map<String, Object> paramsMap = this.selectQueryBuilder.getParamsMap();
        paramsMap.put("tenantId", tenantId);
        paramsMap.put("isDeleted", includeDeleted);
        paramsMap.put("lastModifiedTime", lastChangedSince);
        paramsMap.put("limit", limit);
        paramsMap.put("offset", offset);
        query = this.multiStateInstanceUtil.replaceSchemaPlaceholder((String)query, tenantId);
        return this.namedParameterJdbcTemplate.query((String)query, paramsMap, this.rowMapper);
    }

    public List<String> validateIds(String tenantId, List<String> idsToValidate, String columnName) throws InvalidTenantIdException {
        List<T> validIds = this.findById(tenantId, idsToValidate, false, columnName);
        if (validIds.isEmpty()) {
            return Collections.emptyList();
        }
        Method idMethod = CommonUtils.getIdMethod(validIds, columnName);
        return validIds.stream().map(obj -> (String)ReflectionUtils.invokeMethod((Method)idMethod, (Object)obj)).collect(Collectors.toList());
    }

    public List<String> validateClientReferenceIdsFromDB(String tenantId, List<String> clientReferenceIds, Boolean isDeletedKeyPresent) throws InvalidTenantIdException {
        ArrayList<String> objFound = new ArrayList<String>();
        String query = null;
        query = isDeletedKeyPresent != false ? String.format("SELECT clientReferenceId FROM %s.%s WHERE clientReferenceId IN (:ids) AND isDeleted = false", MultiStateInstanceUtil.SCHEMA_REPLACE_STRING, this.tableName) : String.format("SELECT clientReferenceId FROM %s.%s WHERE clientReferenceId IN (:ids) ", MultiStateInstanceUtil.SCHEMA_REPLACE_STRING, this.tableName);
        HashMap<String, List<String>> paramMap = new HashMap<String, List<String>>();
        paramMap.put("ids", clientReferenceIds);
        query = this.multiStateInstanceUtil.replaceSchemaPlaceholder(query, tenantId);
        objFound.addAll(this.namedParameterJdbcTemplate.queryForList(query, paramMap, String.class));
        return objFound;
    }
}

