/*
 * Decompiled with CFR 0.152.
 */
package org.egov.common.service;

import java.util.List;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.contract.response.ResponseInfo;
import org.egov.common.http.client.ServiceRequestClient;
import org.egov.common.models.idgen.IdDispatchResponse;
import org.egov.common.models.idgen.IdPoolSearch;
import org.egov.common.models.idgen.IdPoolSearchRequest;
import org.egov.common.models.idgen.IdRecord;
import org.egov.common.models.idgen.IdRecordBulkRequest;
import org.egov.common.models.idgen.IdStatus;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnProperty(name={"egov.beneficiary.idgen.integration.enabled"}, havingValue="true")
public class BeneficiaryIdGenService {
    private final String healthIdGenHost;
    private final String healthIdGenSearchPath;
    private final String healthIdGenUpdatePath;
    private final ServiceRequestClient restRepo;

    @Autowired
    public BeneficiaryIdGenService(ServiceRequestClient restRepo, @Value(value="${egov.beneficiary.idgen.host}") String healthIdGenHost, @Value(value="${egov.beneficiary.idgen.idpool.search.path:beneficiary-idgen/id/id_pool/_search}") String healthIdGenSearchPath, @Value(value="${egov.beneficiary.idgen.idpool.update.path:beneficiary-idgen/id/id_pool/_update}") String healthIdGenUpdatePath) {
        this.restRepo = restRepo;
        this.healthIdGenHost = healthIdGenHost;
        this.healthIdGenSearchPath = healthIdGenSearchPath;
        this.healthIdGenUpdatePath = healthIdGenUpdatePath;
    }

    public IdDispatchResponse searchIdRecord(List<String> ids, String status, String tenantId, RequestInfo requestInfo) {
        IdStatus idStatus = null;
        if (!StringUtils.isEmpty((Object)status)) {
            idStatus = IdStatus.valueOf((String)status);
        }
        IdPoolSearchRequest searchRequest = IdPoolSearchRequest.builder().requestInfo(requestInfo).idPoolSearch(IdPoolSearch.builder().idList(ids).status(idStatus).tenantId(tenantId).build()).build();
        StringBuilder uri = new StringBuilder(this.healthIdGenHost).append(this.healthIdGenSearchPath);
        IdDispatchResponse response = this.restRepo.fetchResult(uri, searchRequest, IdDispatchResponse.class);
        return response;
    }

    public ResponseInfo updateIdRecord(List<IdRecord> idRecords, RequestInfo requestInfo) {
        IdRecordBulkRequest updateRequest = IdRecordBulkRequest.builder().requestInfo(requestInfo).idRecords(idRecords).build();
        StringBuilder uri = new StringBuilder(this.healthIdGenHost).append(this.healthIdGenUpdatePath);
        return this.restRepo.fetchResult(uri, updateRequest, ResponseInfo.class);
    }
}

