/*
 * Decompiled with CFR 0.152.
 */
package org.drools.serialization.protobuf.marshalling;

import java.util.HashMap;
import java.util.Map;
import org.drools.core.common.BaseNode;
import org.drools.core.impl.InternalRuleBase;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryTerminalNode;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.WindowNode;

public class RuleBaseNodes {
    public static Map<Integer, BaseNode> getNodeMap(InternalRuleBase kBase) {
        HashMap<Integer, BaseNode> nodes = new HashMap<Integer, BaseNode>();
        RuleBaseNodes.buildNodeMap(kBase, nodes);
        return nodes;
    }

    private static void buildNodeMap(InternalRuleBase kBase, Map<Integer, BaseNode> nodes) {
        for (ObjectTypeNode sink : kBase.getRete().getObjectTypeNodes()) {
            nodes.put(sink.getId(), (BaseNode)sink);
            RuleBaseNodes.addObjectSink(kBase, (ObjectSink)sink, nodes);
        }
    }

    private static void addObjectSink(InternalRuleBase kBase, ObjectSink sink, Map<Integer, BaseNode> nodes) {
        if (sink instanceof LeftTupleSource) {
            LeftTupleSource node = (LeftTupleSource)sink;
            for (LeftTupleSink leftTupleSink : node.getSinkPropagator().getSinks()) {
                RuleBaseNodes.addLeftTupleSink(kBase, leftTupleSink, nodes);
            }
        } else if (sink instanceof WindowNode) {
            WindowNode node = (WindowNode)sink;
            nodes.put(sink.getId(), (BaseNode)sink);
            for (ObjectSink objectSink : node.getObjectSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(kBase, objectSink, nodes);
            }
        } else {
            ObjectSource node = (ObjectSource)sink;
            for (ObjectSink objectSink : node.getObjectSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(kBase, objectSink, nodes);
            }
        }
    }

    private static void addLeftTupleSink(InternalRuleBase kBase, LeftTupleSink sink, Map<Integer, BaseNode> nodes) {
        if (sink instanceof LeftTupleSource) {
            nodes.put(sink.getId(), (BaseNode)((LeftTupleSource)sink));
            for (LeftTupleSink leftTupleSink : sink.getSinkPropagator().getSinks()) {
                RuleBaseNodes.addLeftTupleSink(kBase, leftTupleSink, nodes);
            }
        } else if (sink instanceof ObjectSource) {
            nodes.put(sink.getId(), (BaseNode)((ObjectSource)sink));
            for (ObjectSink objectSink : ((ObjectSource)sink).getObjectSinkPropagator().getSinks()) {
                RuleBaseNodes.addObjectSink(kBase, objectSink, nodes);
            }
        } else if (sink instanceof RuleTerminalNode) {
            nodes.put(sink.getId(), (BaseNode)((RuleTerminalNode)sink));
        } else if (sink instanceof QueryTerminalNode) {
            nodes.put(sink.getId(), (BaseNode)((QueryTerminalNode)sink));
        }
    }
}

