/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.resource.loader;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Named;
import org.codehaus.plexus.resource.PlexusResource;
import org.codehaus.plexus.resource.loader.AbstractResourceLoader;
import org.codehaus.plexus.resource.loader.ResourceNotFoundException;
import org.codehaus.plexus.resource.loader.URLPlexusResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="url")
public class URLResourceLoader
extends AbstractResourceLoader {
    private static final Logger LOGGER = LoggerFactory.getLogger(URLResourceLoader.class);
    public static final String ID = "url";
    protected Map<String, String> templateRoots = new HashMap<String, String>();

    @Override
    public PlexusResource getResource(String name) throws ResourceNotFoundException {
        if (name == null || name.length() == 0) {
            throw new ResourceNotFoundException("URLResourceLoader : No template name provided");
        }
        for (String path : this.paths) {
            try {
                URL u = new URL(path + name);
                final InputStream inputStream = u.openStream();
                if (inputStream == null) continue;
                LOGGER.debug("URLResourceLoader: Found '{}' at '{}'", (Object)name, (Object)path);
                this.templateRoots.put(name, path);
                return new URLPlexusResource(this, u){
                    private boolean useSuper;
                    final /* synthetic */ URLResourceLoader this$0;
                    {
                        this.this$0 = this$0;
                        super(url);
                    }

                    @Override
                    public synchronized InputStream getInputStream() throws IOException {
                        if (!this.useSuper) {
                            this.useSuper = true;
                            return inputStream;
                        }
                        return super.getInputStream();
                    }
                };
            }
            catch (MalformedURLException mue) {
                LOGGER.debug("URLResourceLoader: No valid URL '{}{}'", (Object)path, (Object)name);
            }
            catch (IOException ioe) {
                LOGGER.debug("URLResourceLoader: Exception when looking for '{}' at '{}'", new Object[]{name, path, ioe});
            }
        }
        try {
            URL u = new URL(name);
            final InputStream inputStream = u.openStream();
            if (inputStream != null) {
                return new URLPlexusResource(this, u){
                    private boolean useSuper;
                    final /* synthetic */ URLResourceLoader this$0;
                    {
                        this.this$0 = this$0;
                        super(url);
                    }

                    @Override
                    public synchronized InputStream getInputStream() throws IOException {
                        if (!this.useSuper) {
                            this.useSuper = true;
                            return inputStream;
                        }
                        return super.getInputStream();
                    }
                };
            }
        }
        catch (MalformedURLException mue) {
            LOGGER.debug("URLResourceLoader: No valid URL '{}'", (Object)name);
        }
        catch (IOException ioe) {
            LOGGER.debug("URLResourceLoader: Exception when looking for '{}'", (Object)name, (Object)ioe);
        }
        throw new ResourceNotFoundException(name);
    }
}

