/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.utils.FixedOrderMap;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.StateStore;
import org.apache.kafka.streams.processor.internals.InternalProcessorContext;
import org.apache.kafka.streams.state.internals.OffsetCheckpoint;
import org.apache.kafka.streams.state.internals.RecordConverter;
import org.apache.kafka.streams.state.internals.RecordConverters;
import org.apache.kafka.streams.state.internals.WrappedStateStore;
import org.slf4j.Logger;

final class StateManagerUtil {
    static final String CHECKPOINT_FILE_NAME = ".checkpoint";

    private StateManagerUtil() {
    }

    static RecordConverter converterForStore(StateStore store) {
        return WrappedStateStore.isTimestamped(store) ? RecordConverters.rawValueToTimestampedValue() : RecordConverters.identity();
    }

    public static void reinitializeStateStoresForPartitions(Logger log, boolean eosEnabled, File baseDir, FixedOrderMap<String, Optional<StateStore>> stateStores, Map<String, String> storeToChangelogTopic, Collection<TopicPartition> partitions, InternalProcessorContext processorContext, OffsetCheckpoint checkpointFile, Map<TopicPartition, Long> checkpointFileCache) {
        Map<String, String> changelogTopicToStore = StateManagerUtil.inverseOneToOneMap(storeToChangelogTopic);
        HashSet<String> storesToBeReinitialized = new HashSet<String>();
        for (TopicPartition topicPartition : partitions) {
            checkpointFileCache.remove(topicPartition);
            storesToBeReinitialized.add(changelogTopicToStore.get(topicPartition.topic()));
        }
        if (!eosEnabled) {
            try {
                checkpointFile.write(checkpointFileCache);
            }
            catch (IOException fatalException) {
                log.error("Failed to write offset checkpoint file to {} while re-initializing {}: {}", new Object[]{checkpointFile, stateStores, fatalException});
                throw new StreamsException("Failed to reinitialize global store.", fatalException);
            }
        }
        for (String storeName : storesToBeReinitialized) {
            if (!stateStores.containsKey((Object)storeName)) continue;
            StateStore stateStore = (StateStore)((Optional)stateStores.get((Object)storeName)).orElseThrow(() -> new IllegalStateException("Re-initializing store that has not been initialized. This is a bug in Kafka Streams."));
            try {
                stateStore.close();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            processorContext.uninitialize();
            stateStores.put((Object)storeName, Optional.empty());
            try {
                Utils.delete((File)new File(baseDir + File.separator + "rocksdb" + File.separator + storeName));
            }
            catch (IOException fatalException) {
                log.error("Failed to reinitialize store {}.", (Object)storeName, (Object)fatalException);
                throw new StreamsException(String.format("Failed to reinitialize store %s.", storeName), fatalException);
            }
            try {
                Utils.delete((File)new File(baseDir + File.separator + storeName));
            }
            catch (IOException fatalException) {
                log.error("Failed to reinitialize store {}.", (Object)storeName, (Object)fatalException);
                throw new StreamsException(String.format("Failed to reinitialize store %s.", storeName), fatalException);
            }
            stateStore.init(processorContext, stateStore);
        }
    }

    private static Map<String, String> inverseOneToOneMap(Map<String, String> origin) {
        HashMap<String, String> reversedMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : origin.entrySet()) {
            reversedMap.put(entry.getValue(), entry.getKey());
        }
        return reversedMap;
    }
}

