/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.codestyle;

import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.java.ast.ASTAnnotation;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaParameter;
import net.sourceforge.pmd.lang.java.ast.ASTLocalVariableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTModifierList;
import net.sourceforge.pmd.lang.java.ast.ASTType;
import net.sourceforge.pmd.lang.java.ast.ASTVoidType;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.lang.java.symbols.JTypeDeclSymbol;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.OptionalBool;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ModifierOrderRule
extends AbstractJavaRulechainRule {
    private static final String MSG_KEYWORD_ORDER = "Missorted modifiers `{0} {1}`.";
    private static final String MSG_ANNOTATIONS_SHOULD_BE_BEFORE_MODS = "Missorted modifiers `{0} {1}`. Annotations should be placed before modifiers.";
    private static final String MSG_TYPE_ANNOT_SHOULD_BE_BEFORE_TYPE = "Missorted modifiers `{0} {1}`. Type annotations should be placed before the type they qualify.";
    private static final PropertyDescriptor<TypeAnnotationPosition> TYPE_ANNOT_POLICY = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.enumProperty((String)"typeAnnotations", TypeAnnotationPosition.class, TypeAnnotationPosition::label).desc("Whether type annotations should be placed next to the type they qualify and not before modifiers.")).defaultValue((Object)TypeAnnotationPosition.ANYWHERE)).build();
    private TypeAnnotationPosition typeAnnotPosition;

    public ModifierOrderRule() {
        super(ASTModifierList.class, new Class[0]);
        this.definePropertyDescriptor(TYPE_ANNOT_POLICY);
    }

    public void start(RuleContext ctx) {
        this.typeAnnotPosition = (TypeAnnotationPosition)((Object)this.getProperty(TYPE_ANNOT_POLICY));
    }

    public Object visit(final ASTModifierList modList, Object data) {
        final RuleContext ctx = this.asCtx(data);
        final boolean acceptsTypeAnnot = ModifierOrderRule.contextCanHaveTypeAnnots(modList);
        ModifierOrderEvents eventHandler = new ModifierOrderEvents(){
            private @Nullable LastModSeen lastModSeen;

            @Override
            public boolean recordAnnotation(ASTAnnotation annot) {
                AnnotMod annotMod = new AnnotMod(this.lastModSeen, annot, acceptsTypeAnnot);
                if (this.lastModSeen != null && this.lastModSeen.checkNextAnnot(annotMod, ctx)) {
                    return true;
                }
                this.lastModSeen = annotMod;
                return false;
            }

            @Override
            public boolean recordModifier(JModifier mod, JavaccToken token) {
                KwMod kwMod = new KwMod(mod, token, modList);
                if (this.lastModSeen != null && this.lastModSeen.checkNextKeyword(kwMod, ctx)) {
                    return true;
                }
                this.lastModSeen = kwMod;
                return false;
            }
        };
        ModifierOrderRule.readModifierList(modList, eventHandler);
        return null;
    }

    private static boolean contextCanHaveTypeAnnots(ASTModifierList modList) {
        ASTType followingType = ModifierOrderRule.getFollowingType(modList);
        return followingType != null && !(followingType instanceof ASTVoidType) || ModifierOrderRule.isFollowedByVarKeyword(modList) || modList.getParent() instanceof ASTConstructorDeclaration;
    }

    private static OptionalBool isTypeAnnotation(ASTAnnotation node) {
        JTypeDeclSymbol sym = node.getTypeNode().getTypeMirror().getSymbol();
        if (sym instanceof JClassSymbol) {
            return ((JClassSymbol)sym).mayBeTypeAnnotation(node.getLanguageVersion());
        }
        return OptionalBool.UNKNOWN;
    }

    private static @Nullable ASTType getFollowingType(ASTModifierList node) {
        JavaNode nextSibling = (JavaNode)node.getNextSibling();
        if (nextSibling instanceof ASTType) {
            return (ASTType)nextSibling;
        }
        return null;
    }

    private static boolean isFollowedByVarKeyword(ASTModifierList node) {
        JavaNode parent = (JavaNode)node.getParent();
        if (parent instanceof ASTLambdaParameter) {
            return ((ASTLambdaParameter)parent).hasVarKeyword();
        }
        if (parent instanceof ASTLocalVariableDeclaration) {
            return ((ASTLocalVariableDeclaration)parent).isTypeInferred();
        }
        return false;
    }

    private static void readModifierList(ASTModifierList modList, ModifierOrderEvents events) {
        JavaccToken tok = modList.getFirstToken();
        JavaccToken lastTok = modList.getLastToken();
        int nextAnnotIndex = 0;
        List children = modList.children(ASTAnnotation.class).toList();
        while (tok != lastTok.getNext()) {
            if (tok.isImplicit()) {
                tok = tok.getNext();
                continue;
            }
            if (tok.kind == 94) {
                assert (nextAnnotIndex < children.size()) : "annotation token was not parsed?";
                ASTAnnotation annotation = (ASTAnnotation)children.get(nextAnnotIndex);
                assert (annotation.getFirstToken() == tok) : "next annot index didn't match token";
                ++nextAnnotIndex;
                if (events.recordAnnotation(annotation)) {
                    return;
                }
                tok = annotation.getLastToken();
            } else {
                JModifier mod = ModifierOrderRule.getModFromToken(tok);
                assert (mod != null) : "Token is not a modifier token? " + tok;
                if (events.recordModifier(mod, tok)) {
                    return;
                }
                if (mod == JModifier.NON_SEALED) {
                    tok = tok.getNext();
                    assert (tok.kind == 110);
                    tok = tok.getNext();
                    assert (tok.kind == 82 && tok.getImageCs().contentEquals((CharSequence)"sealed"));
                }
            }
            tok = tok.getNext();
        }
    }

    private static JModifier getModFromToken(JavaccToken tok) {
        switch (tok.kind) {
            case 44: {
                return JModifier.PUBLIC;
            }
            case 43: {
                return JModifier.PROTECTED;
            }
            case 42: {
                return JModifier.PRIVATE;
            }
            case 47: {
                return JModifier.STATIC;
            }
            case 26: {
                return JModifier.FINAL;
            }
            case 10: {
                return JModifier.ABSTRACT;
            }
            case 50: {
                return JModifier.SYNCHRONIZED;
            }
            case 38: {
                return JModifier.NATIVE;
            }
            case 54: {
                return JModifier.TRANSIENT;
            }
            case 58: {
                return JModifier.VOLATILE;
            }
            case 60: {
                return JModifier.STRICTFP;
            }
            case 20: {
                return JModifier.DEFAULT;
            }
            case 82: {
                if (tok.getImageCs().contentEquals((CharSequence)"non")) {
                    return JModifier.NON_SEALED;
                }
                if (!tok.getImageCs().contentEquals((CharSequence)"sealed")) break;
                return JModifier.SEALED;
            }
        }
        return null;
    }

    static interface ModifierOrderEvents {
        public boolean recordAnnotation(ASTAnnotation var1);

        public boolean recordModifier(JModifier var1, JavaccToken var2);
    }

    class AnnotMod
    extends LastModSeen {
        private final @Nullable LastModSeen previous;
        private final ASTAnnotation annot;
        private final OptionalBool isTypeAnnot;

        AnnotMod(LastModSeen previous, ASTAnnotation annot, boolean contextsAcceptsTypeAnnot) {
            this.previous = previous;
            this.annot = annot;
            this.isTypeAnnot = !contextsAcceptsTypeAnnot ? OptionalBool.NO : ModifierOrderRule.isTypeAnnotation(annot);
        }

        @Override
        boolean checkNextKeyword(KwMod next, RuleContext ctx) {
            if (this.isTypeAnnot.isTrue() && ModifierOrderRule.this.typeAnnotPosition == TypeAnnotationPosition.ON_TYPE) {
                ctx.addViolationWithMessage((Node)this.annot, ModifierOrderRule.MSG_TYPE_ANNOT_SHOULD_BE_BEFORE_TYPE, new Object[]{this, next});
                return true;
            }
            if (this.previous instanceof KwMod) {
                if (this.isTypeAnnot.isTrue() && ModifierOrderRule.this.typeAnnotPosition != TypeAnnotationPosition.ON_DECL) {
                    ctx.addViolationWithMessage((Node)this.annot, ModifierOrderRule.MSG_TYPE_ANNOT_SHOULD_BE_BEFORE_TYPE, new Object[]{this, next});
                } else {
                    ctx.addViolationWithMessage((Node)this.annot, ModifierOrderRule.MSG_ANNOTATIONS_SHOULD_BE_BEFORE_MODS, new Object[]{this.previous, this});
                }
                return true;
            }
            return false;
        }

        @Override
        boolean checkNextAnnot(AnnotMod next, RuleContext ctx) {
            return false;
        }

        @Override
        public String toString() {
            return PrettyPrintingUtil.prettyPrintAnnot(this.annot);
        }
    }

    class KwMod
    extends LastModSeen {
        private final JModifier mod;
        private final JavaccToken token;
        private final JavaNode reportNode;

        KwMod(JModifier mod, JavaccToken token, JavaNode reportNode) {
            this.mod = mod;
            this.token = token;
            this.reportNode = reportNode;
        }

        @Override
        boolean checkNextKeyword(KwMod next, RuleContext ctx) {
            if (this.mod.compareTo(next.mod) > 0) {
                ctx.addViolationWithPosition((Node)this.reportNode, this.token, ModifierOrderRule.MSG_KEYWORD_ORDER, new Object[]{this, next});
                return true;
            }
            return false;
        }

        @Override
        boolean checkNextAnnot(AnnotMod next, RuleContext ctx) {
            if (next.isTypeAnnot != OptionalBool.NO && ModifierOrderRule.this.typeAnnotPosition != TypeAnnotationPosition.ON_DECL) {
                return false;
            }
            ctx.addViolationWithPosition((Node)this.reportNode, this.token, ModifierOrderRule.MSG_ANNOTATIONS_SHOULD_BE_BEFORE_MODS, new Object[]{this, next});
            return true;
        }

        @Override
        public String toString() {
            return this.mod.getToken();
        }
    }

    static abstract class LastModSeen {
        LastModSeen() {
        }

        abstract boolean checkNextKeyword(KwMod var1, RuleContext var2);

        abstract boolean checkNextAnnot(AnnotMod var1, RuleContext var2);

        public abstract String toString();
    }

    public static enum TypeAnnotationPosition {
        ON_TYPE,
        ON_DECL,
        ANYWHERE;


        String label() {
            switch (this) {
                case ON_TYPE: {
                    return "ontype";
                }
                case ON_DECL: {
                    return "ondecl";
                }
                case ANYWHERE: {
                    return "anywhere";
                }
            }
            throw AssertionUtil.shouldNotReachHere((String)"exhaustive switch");
        }
    }
}

