/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types;

import java.lang.reflect.Modifier;
import java.util.List;
import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.JExecutableSymbol;
import net.sourceforge.pmd.lang.java.types.JArrayType;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.JTypeVar;
import net.sourceforge.pmd.lang.java.types.JTypeVisitable;
import net.sourceforge.pmd.lang.java.types.JTypeVisitor;
import net.sourceforge.pmd.lang.java.types.SubstVar;
import net.sourceforge.pmd.lang.java.types.TypeSystem;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface JMethodSig
extends JTypeVisitable {
    public TypeSystem getTypeSystem();

    public JExecutableSymbol getSymbol();

    default public String getName() {
        return this.getSymbol().getSimpleName();
    }

    default public boolean isConstructor() {
        return "new".equals(this.getName());
    }

    default public int getModifiers() {
        return this.getSymbol().getModifiers();
    }

    public JTypeMirror getDeclaringType();

    public JTypeMirror getAnnotatedReceiverType();

    public JTypeMirror getReturnType();

    public JMethodSig getErasure();

    public List<JTypeMirror> getFormalParameters();

    default public int getArity() {
        return this.getSymbol().getArity();
    }

    public List<JTypeVar> getTypeParameters();

    public List<JTypeMirror> getThrownExceptions();

    default public boolean isAbstract() {
        return Modifier.isAbstract(this.getModifiers());
    }

    default public boolean isStatic() {
        return Modifier.isStatic(this.getModifiers());
    }

    default public boolean isVarargs() {
        return this.getSymbol().isVarargs();
    }

    default public boolean isGeneric() {
        return !this.getTypeParameters().isEmpty();
    }

    default public JTypeMirror ithFormalParam(int i, boolean varargs) {
        if (!1.$assertionsDisabled && varargs && !this.isVarargs()) {
            throw new AssertionError((Object)("Method is not varargs " + this));
        }
        List<JTypeMirror> formals = this.getFormalParameters();
        if (varargs) {
            if (!1.$assertionsDisabled && i < 0) {
                throw new AssertionError((Object)("Argument index out of range: " + i));
            }
            if (i >= formals.size() - 1) {
                JTypeMirror lastFormal = formals.get(formals.size() - 1);
                return ((JArrayType)lastFormal).getComponentType();
            }
        } else if (!(1.$assertionsDisabled || i >= 0 && i < formals.size())) {
            throw new AssertionError((Object)("Argument index out of range: " + i));
        }
        return formals.get(i);
    }

    @Override
    public JMethodSig subst(Function<? super SubstVar, ? extends @NonNull JTypeMirror> var1);

    @Override
    default public <T, P> T acceptVisitor(JTypeVisitor<T, P> visitor, P p) {
        return visitor.visitMethodType(this, p);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

