/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Objects;
import net.sourceforge.pmd.lang.java.ast.ASTMemberValue;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowRHS;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.ast.ExprContext;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface ASTExpression
extends TypeNode,
ASTMemberValue,
ASTSwitchArrowRHS {
    default public boolean isExpression() {
        return true;
    }

    public int getParenthesisDepth();

    default public boolean isParenthesized() {
        return this.getParenthesisDepth() > 0;
    }

    @Override
    default public @Nullable Object getConstValue() {
        ConstResult res = this.getConstFoldingResult();
        return res.isCompileTimeConstant() ? res.getValue() : null;
    }

    default public @NonNull ConstResult getConstFoldingResult() {
        return ConstResult.NO_CONST_VALUE;
    }

    default public boolean isCompileTimeConstant() {
        return this.getConstFoldingResult().isCompileTimeConstant();
    }

    default public @NonNull ExprContext getConversionContext() {
        return this.getRoot().getLazyTypeResolver().getConversionContextForExternalUse(this);
    }

    public static final class ConstResult {
        private final boolean isCompileTimeConstant;
        private final @Nullable Object value;
        static final ConstResult NO_CONST_VALUE = new ConstResult(false, null);
        static final ConstResult BOOL_TRUE = ConstResult.ctConst(true);
        static final ConstResult BOOL_FALSE = ConstResult.ctConst(false);

        ConstResult(boolean isCompileTimeConstant, @Nullable Object value) {
            this.isCompileTimeConstant = isCompileTimeConstant && value != null;
            this.value = value;
        }

        static @NonNull ConstResult ctConst(@NonNull Object result) {
            return new ConstResult(true, Objects.requireNonNull(result));
        }

        static @NonNull ConstResult ctConstIfNotNull(@Nullable Object result) {
            if (result == null) {
                return NO_CONST_VALUE;
            }
            return new ConstResult(true, Objects.requireNonNull(result));
        }

        public boolean isCompileTimeConstant() {
            return this.isCompileTimeConstant;
        }

        public boolean hasValue() {
            return this.value != null;
        }

        public @Nullable Object getValue() {
            return this.value;
        }
    }
}

