/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender.observation;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.docs.ObservationDocumentation;
import reactor.kafka.sender.observation.KafkaRecordSenderContext;
import reactor.kafka.sender.observation.KafkaSenderObservationConvention;

public enum KafkaSenderObservation implements ObservationDocumentation
{
    SENDER_OBSERVATION{

        public Class<? extends ObservationConvention<? extends Observation.Context>> getDefaultConvention() {
            return DefaultKafkaSenderObservationConvention.class;
        }

        public String getPrefix() {
            return "reactor.kafka.sender";
        }

        public KeyName[] getLowCardinalityKeyNames() {
            return SenderLowCardinalityTags.values();
        }
    };


    public static class DefaultKafkaSenderObservationConvention
    implements KafkaSenderObservationConvention {
        public static final DefaultKafkaSenderObservationConvention INSTANCE = new DefaultKafkaSenderObservationConvention();

        public KeyValues getLowCardinalityKeyValues(KafkaRecordSenderContext context) {
            return KeyValues.of((KeyValue[])new KeyValue[]{SenderLowCardinalityTags.PRODUCER_ID.withValue(context.getProducerId()), SenderLowCardinalityTags.COMPONENT_TYPE.withValue("sender")});
        }
    }

    public static enum SenderLowCardinalityTags implements KeyName
    {
        PRODUCER_ID{

            public String asString() {
                return "reactor.kafka.client.id";
            }
        }
        ,
        COMPONENT_TYPE{

            public String asString() {
                return "reactor.kafka.type";
            }
        };

    }
}

