/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.jdbc;

import io.opentracing.contrib.jdbc.TracingConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TracingDriver
implements Driver {
    private static final Driver INSTANCE = new TracingDriver();
    private static final String TRACE_WITH_ACTIVE_SPAN_ONLY = "traceWithActiveSpanOnly";
    private static final String WITH_ACTIVE_SPAN_ONLY = "traceWithActiveSpanOnly=true";
    public static final String IGNORE_FOR_TRACING_REGEX = "ignoreForTracing=\"((?:\\\\\"|[^\"])*)\"[;]*";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (url == null) {
            throw new SQLException("url is required");
        }
        if (!this.acceptsURL(url)) {
            return null;
        }
        String realUrl = this.extractRealUrl(url);
        String dbType = this.extractDbType(realUrl);
        String dbUser = info.getProperty("user");
        Driver wrappedDriver = this.findDriver(realUrl);
        Connection connection = wrappedDriver.connect(realUrl, info);
        return new TracingConnection(connection, dbType, dbUser, url.contains(WITH_ACTIVE_SPAN_ONLY), this.extractIgnoredStatements(url));
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return url != null && url.startsWith("jdbc:tracing:");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return this.findDriver(url).getPropertyInfo(url, info);
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return true;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    private Driver findDriver(String realUrl) throws SQLException {
        Driver wrappedDriver = null;
        for (Driver driver : this.registeredDrivers()) {
            try {
                if (!driver.acceptsURL(realUrl)) continue;
                wrappedDriver = driver;
                break;
            }
            catch (SQLException sQLException) {
            }
        }
        if (wrappedDriver == null) {
            throw new SQLException("Unable to find a driver that accepts " + realUrl);
        }
        return wrappedDriver;
    }

    private List<Driver> registeredDrivers() {
        ArrayList<Driver> result = new ArrayList<Driver>();
        Enumeration<Driver> driverEnumeration = DriverManager.getDrivers();
        while (driverEnumeration.hasMoreElements()) {
            result.add(driverEnumeration.nextElement());
        }
        return result;
    }

    private String extractRealUrl(String url) {
        String extracted = url.startsWith("jdbc:tracing:") ? url.replace("tracing:", "") : url;
        return extracted.replaceAll("traceWithActiveSpanOnly=(true|false)[;]*", "").replaceAll(IGNORE_FOR_TRACING_REGEX, "").replaceAll("\\?$", "");
    }

    private String extractDbType(String realUrl) {
        return realUrl.split(":")[1];
    }

    private Set<String> extractIgnoredStatements(String url) {
        String regex = IGNORE_FOR_TRACING_REGEX;
        Pattern pattern = Pattern.compile(IGNORE_FOR_TRACING_REGEX);
        Matcher matcher = pattern.matcher(url);
        HashSet<String> results = new HashSet<String>();
        while (matcher.find()) {
            String rawValue = matcher.group(1);
            String finalValue = rawValue.replace("\\\"", "\"");
            results.add(finalValue);
        }
        return results;
    }

    static {
        try {
            DriverManager.registerDriver(INSTANCE);
        }
        catch (SQLException e) {
            throw new IllegalStateException("Could not register TracingDriver with DriverManager", e);
        }
    }
}

