/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.memory;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import jdk.jfr.consumer.RecordedEvent;

public final class ObjectAllocationInNewTlabHandler
implements RecordedEventHandler {
    private static final String EVENT_NAME = "jdk.ObjectAllocationInNewTLAB";
    private static final String TLAB_SIZE = "tlabSize";
    private final LongHistogram histogram;
    private final Attributes attributes;

    public ObjectAllocationInNewTlabHandler(Meter meter) {
        this.histogram = meter.histogramBuilder("jvm.memory.allocation").setDescription("Measure of memory allocations.").setUnit("By").ofLongs().build();
        this.attributes = Attributes.of(Constants.ATTR_ARENA_NAME, (Object)"TLAB");
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.MEMORY_ALLOCATION_METRICS;
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.histogram.record(ev.getLong(TLAB_SIZE), this.attributes);
    }
}

