/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.spring.autoconfigure.export.newrelic;

import io.micrometer.core.instrument.Clock;
import io.micrometer.newrelic.NewRelicConfig;
import io.micrometer.newrelic.NewRelicMeterRegistry;
import io.micrometer.spring.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import io.micrometer.spring.autoconfigure.MetricsAutoConfiguration;
import io.micrometer.spring.autoconfigure.export.StringToDurationConverter;
import io.micrometer.spring.autoconfigure.export.newrelic.NewRelicProperties;
import io.micrometer.spring.autoconfigure.export.newrelic.NewRelicPropertiesConfigAdapter;
import io.micrometer.spring.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@AutoConfigureBefore(value={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class})
@AutoConfigureAfter(value={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={NewRelicMeterRegistry.class})
@ConditionalOnProperty(prefix="management.metrics.export.newrelic", name={"enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={NewRelicProperties.class})
@Import(value={StringToDurationConverter.class})
public class NewRelicMetricsExportAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public NewRelicConfig newRelicConfig(NewRelicProperties props) {
        return new NewRelicPropertiesConfigAdapter(props);
    }

    @Bean
    @ConditionalOnMissingBean
    public NewRelicMeterRegistry newRelicMeterRegistry(NewRelicConfig config, Clock clock) {
        return new NewRelicMeterRegistry(config, clock);
    }
}

