/**
 * Copyright 2018 VMware, Inc.
 * <p>
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * <p>
 * https://www.apache.org/licenses/LICENSE-2.0
 * <p>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.micrometer.spring.autoconfigure.export.logging;

import io.micrometer.spring.autoconfigure.export.properties.StepRegistryProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * {@link ConfigurationProperties} for configuring metrics logging.
 *
 * @author Jon Schneider
 * @since 1.1.0
 */
@ConfigurationProperties(prefix = "management.metrics.export.logging")
public class LoggingRegistryProperties extends StepRegistryProperties {

    /**
     * Whether counters and timers that have no activity in an interval are still logged.
     */
    private boolean logInactive = false;

    public boolean isLogInactive() {
        return logInactive;
    }

    public void setLogInactive(boolean logInactive) {
        this.logInactive = logInactive;
    }
}
