/*
 * Decompiled with CFR 0.152.
 */
package com.yy.androidlib.util.http;

import com.loopj.android.http.AsyncHttpClient;
import com.loopj.android.http.FileAsyncHttpResponseHandler;
import com.loopj.android.http.RequestParams;
import com.loopj.android.http.ResponseHandlerInterface;
import com.loopj.android.http.TextHttpResponseHandler;
import com.yy.androidlib.util.http.FileDataFormEntry;
import com.yy.androidlib.util.http.FormEntry;
import com.yy.androidlib.util.http.Profiler;
import com.yy.androidlib.util.logging.Logger;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.http.Header;

public class AsyncHttp {
    private static final String TAG = "AsyncHttp";
    private static AsyncHttpClient asyncHttpClient = new AsyncHttpClient();
    private static Profiler profiling;

    public static void enableProfiling(Profiler profiling) {
        AsyncHttp.profiling = profiling;
    }

    public static void post(final String url, List<FormEntry> entries, final ResultCallback callback, Header ... headers) {
        RequestParams params = new RequestParams();
        block5: for (FormEntry entry : entries) {
            switch (entry.type) {
                case File: {
                    try {
                        params.put(entry.name, new File(entry.value));
                    }
                    catch (FileNotFoundException e) {
                        Logger.error(TAG, "file not found %s", entry.value, e);
                    }
                    continue block5;
                }
            }
            if (entry instanceof FileDataFormEntry) {
                FileDataFormEntry fileDataFormEntry = (FileDataFormEntry)entry;
                params.put(fileDataFormEntry.name, fileDataFormEntry.byteValue);
                continue;
            }
            params.put(entry.name, entry.value);
        }
        final long startTime = System.currentTimeMillis();
        asyncHttpClient.post(null, url, headers, params, null, (ResponseHandlerInterface)new TextHttpResponseHandler(){

            @Override
            public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
                Logger.error(AsyncHttp.TAG, "http request error, statusCode: %d, responseString: %s, url: %s, thread: %s", statusCode, responseString, url, Thread.currentThread().getName(), throwable);
                callback.onFailure(url, statusCode, -3, throwable);
                AsyncHttp.report(startTime, url, Profiler.Status.ERROR.value);
            }

            @Override
            public void onSuccess(int statusCode, Header[] headers, String responseString) {
                callback.onSuccess(url, statusCode, responseString);
                AsyncHttp.report(startTime, url, Profiler.Status.SUCCESS.value);
            }
        });
    }

    @Deprecated
    public static void post(String url, List<FormEntry> entries, Callback callback, Header ... headers) {
        AsyncHttp.post(url, entries, AsyncHttp.transferToNewCallback(callback), headers);
    }

    public static void download(final String url, File file, final ResultCallback callback) {
        final long startTime = System.currentTimeMillis();
        asyncHttpClient.get(url, null, (ResponseHandlerInterface)new FileAsyncHttpResponseHandler(file){

            @Override
            public void onFailure(int statusCode, Header[] headers, Throwable throwable, File file) {
                callback.onFailure(url, statusCode, -3, throwable);
                AsyncHttp.report(startTime, url, Profiler.Status.ERROR.value);
            }

            @Override
            public void onSuccess(int statusCode, Header[] headers, File response) {
                callback.onSuccess(url, statusCode, "");
                AsyncHttp.report(startTime, url, Profiler.Status.SUCCESS.value);
            }
        });
    }

    @Deprecated
    public static void download(String url, File file, Callback callback) {
        AsyncHttp.download(url, file, AsyncHttp.transferToNewCallback(callback));
    }

    private static ResultCallback transferToNewCallback(final Callback callback) {
        return new ResultCallback(){

            @Override
            public void onSuccess(String url, int statusCode, String result) {
                callback.onResult(url, true, statusCode, result);
            }

            @Override
            public void onFailure(String url, int statusCode, int errorType, Throwable throwable) {
                callback.onResult(url, false, errorType, "");
            }
        };
    }

    public static void get(final String url, final ResultCallback callback, Header ... headers) {
        RequestParams params = new RequestParams();
        final long startTime = System.currentTimeMillis();
        asyncHttpClient.get(null, url, headers, params, new TextHttpResponseHandler(){

            @Override
            public void onFailure(int statusCode, Header[] headers, String responseString, Throwable throwable) {
                Logger.error(AsyncHttp.TAG, "http request error, statusCode: %d, responseString: %s, url: %s, thread: %s", statusCode, responseString, url, Thread.currentThread().getName(), throwable);
                callback.onFailure(url, statusCode, -3, throwable);
                AsyncHttp.report(startTime, url, Profiler.Status.ERROR.value);
            }

            @Override
            public void onSuccess(int statusCode, Header[] headers, String responseString) {
                callback.onSuccess(url, statusCode, responseString);
                AsyncHttp.report(startTime, url, Profiler.Status.SUCCESS.value);
            }
        });
    }

    @Deprecated
    public static void get(String url, Callback callback, Header ... headers) {
        AsyncHttp.get(url, AsyncHttp.transferToNewCallback(callback), headers);
    }

    private static void report(long startTime, String url, int status) {
        if (profiling != null) {
            profiling.report(startTime, url, status);
        }
    }

    public static void setTimeout(int value) {
        asyncHttpClient.setTimeout(value);
    }

    @Deprecated
    public static interface Callback {
        public static final int NETWORK_NOT_AVAILABLE = -1;
        public static final int URL_NULL = -2;
        public static final int EXCEPTION = -3;

        public void onResult(String var1, boolean var2, int var3, String var4);
    }

    public static interface ResultCallback {
        public static final int NETWORK_NOT_AVAILABLE = -1;
        public static final int URL_NULL = -2;
        public static final int EXCEPTION = -3;

        public void onSuccess(String var1, int var2, String var3);

        public void onFailure(String var1, int var2, int var3, Throwable var4);
    }
}

