/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.discovery;

import com.netflix.loadbalancer.Server;
import com.netflix.zuul.discovery.ResolverResult;
import java.util.Objects;

public final class NonDiscoveryServer
implements ResolverResult {
    private final Server server;

    public NonDiscoveryServer(String host, int port) {
        Objects.requireNonNull(host, "host name");
        this.server = new Server(host, this.validatePort(port));
    }

    @Override
    public String getHost() {
        return this.server.getHost();
    }

    @Override
    public int getPort() {
        return this.server.getPort();
    }

    @Override
    public boolean isDiscoveryEnabled() {
        return false;
    }

    private int validatePort(int port) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("port out of range:" + port);
        }
        return port;
    }
}

