/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.zuul.discovery;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import com.google.common.collect.Sets;
import com.netflix.client.config.CommonClientConfigKey;
import com.netflix.client.config.IClientConfig;
import com.netflix.loadbalancer.DynamicServerListLoadBalancer;
import com.netflix.loadbalancer.Server;
import com.netflix.niws.loadbalancer.DiscoveryEnabledServer;
import com.netflix.zuul.discovery.DiscoveryResult;
import com.netflix.zuul.resolver.Resolver;
import com.netflix.zuul.resolver.ResolverListener;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicServerResolver
implements Resolver<DiscoveryResult> {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicServerResolver.class);
    private final DynamicServerListLoadBalancer<?> loadBalancer;
    private ResolverListener<DiscoveryResult> listener;

    @Deprecated
    public DynamicServerResolver(IClientConfig clientConfig, ResolverListener<DiscoveryResult> listener) {
        this.loadBalancer = DynamicServerResolver.createLoadBalancer(clientConfig);
        this.loadBalancer.addServerListChangeListener(this::onUpdate);
        this.listener = listener;
    }

    public DynamicServerResolver(IClientConfig clientConfig) {
        this(DynamicServerResolver.createLoadBalancer(clientConfig));
    }

    public DynamicServerResolver(DynamicServerListLoadBalancer<?> loadBalancer) {
        this.loadBalancer = Objects.requireNonNull(loadBalancer);
    }

    @Override
    public void setListener(ResolverListener<DiscoveryResult> listener) {
        if (this.listener != null) {
            LOG.warn("Ignoring call to setListener, because a listener was already set");
            return;
        }
        this.listener = Objects.requireNonNull(listener);
        this.loadBalancer.addServerListChangeListener(this::onUpdate);
    }

    @Override
    public DiscoveryResult resolve(@Nullable Object key) {
        Server server = this.loadBalancer.chooseServer(key);
        return server != null ? new DiscoveryResult((DiscoveryEnabledServer)server, this.loadBalancer.getLoadBalancerStats()) : DiscoveryResult.EMPTY;
    }

    @Override
    public boolean hasServers() {
        return !this.loadBalancer.getReachableServers().isEmpty();
    }

    @Override
    public void shutdown() {
        this.loadBalancer.shutdown();
    }

    private static DynamicServerListLoadBalancer<?> createLoadBalancer(IClientConfig clientConfig) {
        DynamicServerListLoadBalancer lb;
        String loadBalancerClassName = (String)clientConfig.get(CommonClientConfigKey.NFLoadBalancerClassName, (Object)"com.netflix.loadbalancer.ZoneAwareLoadBalancer");
        try {
            Class<?> clazz = Class.forName(loadBalancerClassName);
            lb = clazz.asSubclass(DynamicServerListLoadBalancer.class).getConstructor(new Class[0]).newInstance(new Object[0]);
            lb.initWithNiwsConfig(clientConfig);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new IllegalStateException("Could not instantiate LoadBalancer " + loadBalancerClassName, e);
        }
        return lb;
    }

    @VisibleForTesting
    void onUpdate(List<Server> oldList, List<Server> newList) {
        HashSet<Server> oldSet = new HashSet<Server>(oldList);
        HashSet<Server> newSet = new HashSet<Server>(newList);
        List discoveryResults = Sets.difference(oldSet, newSet).stream().map(server -> new DiscoveryResult((DiscoveryEnabledServer)server, this.loadBalancer.getLoadBalancerStats())).collect(Collectors.toList());
        this.listener.onChange(discoveryResults);
    }
}

