/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.signatures.validation.v1;

import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class TrustedCertificatesStore {
    private final Map<String, Certificate> generallyTrustedCertificates = new HashMap<String, Certificate>();
    private final Map<String, Certificate> ocspTrustedCertificates = new HashMap<String, Certificate>();
    private final Map<String, Certificate> timestampTrustedCertificates = new HashMap<String, Certificate>();
    private final Map<String, Certificate> crlTrustedCertificates = new HashMap<String, Certificate>();
    private final Map<String, Certificate> caTrustedCertificates = new HashMap<String, Certificate>();

    public void addGenerallyTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            this.generallyTrustedCertificates.put(((X509Certificate)certificate).getSubjectX500Principal().getName(), certificate);
        }
    }

    public void addOcspTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            this.ocspTrustedCertificates.put(((X509Certificate)certificate).getSubjectX500Principal().getName(), certificate);
        }
    }

    public void addCrlTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            this.crlTrustedCertificates.put(((X509Certificate)certificate).getSubjectX500Principal().getName(), certificate);
        }
    }

    public void addTimestampTrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            this.timestampTrustedCertificates.put(((X509Certificate)certificate).getSubjectX500Principal().getName(), certificate);
        }
    }

    public void addCATrustedCertificates(Collection<Certificate> certificates) {
        for (Certificate certificate : certificates) {
            this.caTrustedCertificates.put(((X509Certificate)certificate).getSubjectX500Principal().getName(), certificate);
        }
    }

    public boolean isCertificateGenerallyTrusted(Certificate certificate) {
        return this.generallyTrustedCertificates.containsKey(((X509Certificate)certificate).getSubjectX500Principal().getName());
    }

    public boolean isCertificateTrustedForOcsp(Certificate certificate) {
        return this.ocspTrustedCertificates.containsKey(((X509Certificate)certificate).getSubjectX500Principal().getName());
    }

    public boolean isCertificateTrustedForCrl(Certificate certificate) {
        return this.crlTrustedCertificates.containsKey(((X509Certificate)certificate).getSubjectX500Principal().getName());
    }

    public boolean isCertificateTrustedForTimestamp(Certificate certificate) {
        return this.timestampTrustedCertificates.containsKey(((X509Certificate)certificate).getSubjectX500Principal().getName());
    }

    public boolean isCertificateTrustedForCA(Certificate certificate) {
        return this.caTrustedCertificates.containsKey(((X509Certificate)certificate).getSubjectX500Principal().getName());
    }

    public Certificate getGenerallyTrustedCertificate(String certificateName) {
        return this.generallyTrustedCertificates.get(certificateName);
    }

    public Certificate getCertificateTrustedForOcsp(String certificateName) {
        return this.ocspTrustedCertificates.get(certificateName);
    }

    public Certificate getCertificateTrustedForCrl(String certificateName) {
        return this.crlTrustedCertificates.get(certificateName);
    }

    public Certificate getCertificateTrustedForTimestamp(String certificateName) {
        return this.timestampTrustedCertificates.get(certificateName);
    }

    public Certificate getCertificateTrustedForCA(String certificateName) {
        return this.caTrustedCertificates.get(certificateName);
    }

    public Certificate getKnownCertificate(String certificateName) {
        if (this.generallyTrustedCertificates.containsKey(certificateName)) {
            return this.generallyTrustedCertificates.get(certificateName);
        }
        if (this.ocspTrustedCertificates.containsKey(certificateName)) {
            return this.ocspTrustedCertificates.get(certificateName);
        }
        if (this.crlTrustedCertificates.containsKey(certificateName)) {
            return this.crlTrustedCertificates.get(certificateName);
        }
        if (this.timestampTrustedCertificates.containsKey(certificateName)) {
            return this.timestampTrustedCertificates.get(certificateName);
        }
        return this.caTrustedCertificates.get(certificateName);
    }

    public Collection<Certificate> getAllTrustedCertificates() {
        ArrayList<Certificate> certificates = new ArrayList<Certificate>();
        certificates.addAll(this.generallyTrustedCertificates.values());
        certificates.addAll(this.ocspTrustedCertificates.values());
        certificates.addAll(this.crlTrustedCertificates.values());
        certificates.addAll(this.timestampTrustedCertificates.values());
        certificates.addAll(this.caTrustedCertificates.values());
        return certificates;
    }
}

