/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.layout.renderer;

import com.itextpdf.io.font.otf.Glyph;
import com.itextpdf.io.font.otf.GlyphLine;
import com.itextpdf.io.util.ArrayUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.TextUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.element.TabStop;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.layout.LayoutResult;
import com.itextpdf.layout.layout.LineLayoutContext;
import com.itextpdf.layout.layout.LineLayoutResult;
import com.itextpdf.layout.layout.MinMaxWidthLayoutResult;
import com.itextpdf.layout.layout.TextLayoutResult;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.minmaxwidth.MinMaxWidthUtils;
import com.itextpdf.layout.property.BaseDirection;
import com.itextpdf.layout.property.FloatPropertyValue;
import com.itextpdf.layout.property.Leading;
import com.itextpdf.layout.property.OverflowPropertyValue;
import com.itextpdf.layout.property.TabAlignment;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.AbstractRenderer;
import com.itextpdf.layout.renderer.AbstractWidthHandler;
import com.itextpdf.layout.renderer.BlockRenderer;
import com.itextpdf.layout.renderer.FloatingHelper;
import com.itextpdf.layout.renderer.ILeafElementRenderer;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ImageRenderer;
import com.itextpdf.layout.renderer.MaxSumWidthHandler;
import com.itextpdf.layout.renderer.TabRenderer;
import com.itextpdf.layout.renderer.TableRenderer;
import com.itextpdf.layout.renderer.TextRenderer;
import com.itextpdf.layout.renderer.TypographyUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineRenderer
extends AbstractRenderer {
    protected float maxAscent;
    protected float maxDescent;
    protected byte[] levels;
    private static final float MIN_MAX_WIDTH_CORRECTION_EPS = 0.001f;
    private float maxTextAscent;
    private float maxTextDescent;
    private float maxBlockAscent;
    private float maxBlockDescent;

    @Override
    public LayoutResult layout(LayoutContext layoutContext) {
        LineRenderer processed;
        LineLayoutContext lineLayoutContext;
        Rectangle layoutBox = layoutContext.getArea().getBBox().clone();
        boolean wasParentsHeightClipped = layoutContext.isClippedHeight();
        List<Rectangle> floatRendererAreas = layoutContext.getFloatRendererAreas();
        OverflowPropertyValue oldXOverflow = null;
        boolean wasXOverflowChanged = false;
        if (floatRendererAreas != null) {
            float layoutWidth = layoutBox.getWidth();
            FloatingHelper.adjustLineAreaAccordingToFloats(floatRendererAreas, layoutBox);
            if (layoutWidth > layoutBox.getWidth()) {
                oldXOverflow = (OverflowPropertyValue)((Object)this.getProperty(103));
                wasXOverflowChanged = true;
                this.setProperty(103, (Object)OverflowPropertyValue.FIT);
            }
        }
        LineLayoutContext lineLayoutContext2 = lineLayoutContext = layoutContext instanceof LineLayoutContext ? (LineLayoutContext)layoutContext : new LineLayoutContext(layoutContext);
        if (lineLayoutContext.getTextIndent() != 0.0f) {
            layoutBox.moveRight(lineLayoutContext.getTextIndent()).setWidth(layoutBox.getWidth() - lineLayoutContext.getTextIndent());
        }
        this.occupiedArea = new LayoutArea(layoutContext.getArea().getPageNumber(), layoutBox.clone().moveUp(layoutBox.getHeight()).setHeight(0.0f).setWidth(0.0f));
        float curWidth = 0.0f;
        this.maxAscent = 0.0f;
        this.maxDescent = 0.0f;
        this.maxTextAscent = 0.0f;
        this.maxTextDescent = 0.0f;
        this.maxBlockAscent = -1.0E20f;
        this.maxBlockDescent = 1.0E20f;
        int childPos = 0;
        MinMaxWidth minMaxWidth = new MinMaxWidth();
        MaxSumWidthHandler widthHandler = new MaxSumWidthHandler(minMaxWidth);
        this.updateChildrenParent();
        this.resolveChildrenFonts();
        int totalNumberOfTrimmedGlyphs = this.trimFirst();
        BaseDirection baseDirection = this.applyOtf();
        this.updateBidiLevels(totalNumberOfTrimmedGlyphs, baseDirection);
        boolean anythingPlaced = false;
        TabStop hangingTabStop = null;
        LayoutResult result = null;
        boolean floatsPlaced = false;
        LinkedHashMap<Integer, IRenderer> floatsToNextPageSplitRenderers = new LinkedHashMap<Integer, IRenderer>();
        ArrayList<IRenderer> floatsToNextPageOverflowRenderers = new ArrayList<IRenderer>();
        ArrayList<IRenderer> floatsOverflowedToNextLine = new ArrayList<IRenderer>();
        int lastTabIndex = 0;
        while (childPos < this.childRenderers.size()) {
            boolean shouldBreakLayouting;
            float maxChildWidth;
            float minChildWidth;
            boolean isChildFloating;
            IRenderer childRenderer = (IRenderer)this.childRenderers.get(childPos);
            LayoutResult childResult = null;
            Rectangle bbox = new Rectangle(layoutBox.getX() + curWidth, layoutBox.getY(), layoutBox.getWidth() - curWidth, layoutBox.getHeight());
            if (childRenderer instanceof TextRenderer) {
                childRenderer.deleteOwnProperty(15);
                childRenderer.deleteOwnProperty(78);
            } else if (childRenderer instanceof TabRenderer) {
                if (hangingTabStop != null) {
                    IRenderer tabRenderer = (IRenderer)this.childRenderers.get(childPos - 1);
                    tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox), wasParentsHeightClipped));
                    curWidth += tabRenderer.getOccupiedArea().getBBox().getWidth();
                    ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(tabRenderer.getOccupiedArea().getBBox().getWidth());
                }
                hangingTabStop = this.calculateTab(childRenderer, curWidth, layoutBox.getWidth());
                if (childPos == this.childRenderers.size() - 1) {
                    hangingTabStop = null;
                }
                if (hangingTabStop != null) {
                    lastTabIndex = childPos++;
                    continue;
                }
            }
            if (hangingTabStop != null && hangingTabStop.getTabAlignment() == TabAlignment.ANCHOR && childRenderer instanceof TextRenderer) {
                childRenderer.setProperty(66, hangingTabStop.getTabAnchor());
            }
            Object childWidth = childRenderer.getProperty(77);
            boolean childWidthWasReplaced = false;
            boolean childRendererHasOwnWidthProperty = childRenderer.hasOwnProperty(77);
            if (childWidth instanceof UnitValue && ((UnitValue)childWidth).isPercentValue()) {
                float normalizedChildWidth = ((UnitValue)childWidth).getValue() / 100.0f * layoutContext.getArea().getBBox().getWidth();
                if ((normalizedChildWidth = this.decreaseRelativeWidthByChildAdditionalWidth(childRenderer, normalizedChildWidth)) > 0.0f) {
                    childRenderer.setProperty(77, UnitValue.createPointValue(normalizedChildWidth));
                    childWidthWasReplaced = true;
                }
            }
            Object kidFloatPropertyVal = (FloatPropertyValue)((Object)childRenderer.getProperty(99));
            boolean bl = isChildFloating = childRenderer instanceof AbstractRenderer && FloatingHelper.isRendererFloating(childRenderer, kidFloatPropertyVal);
            if (isChildFloating) {
                childResult = null;
                MinMaxWidth kidMinMaxWidth = FloatingHelper.calculateMinMaxWidthForFloat((AbstractRenderer)childRenderer, kidFloatPropertyVal);
                float floatingBoxFullWidth = kidMinMaxWidth.getMaxWidth();
                if (!wasXOverflowChanged && childPos > 0) {
                    oldXOverflow = (OverflowPropertyValue)((Object)this.getProperty(103));
                    wasXOverflowChanged = true;
                    this.setProperty(103, (Object)OverflowPropertyValue.FIT);
                }
                if (!lineLayoutContext.isFloatOverflowedToNextPageWithNothing() && floatsOverflowedToNextLine.isEmpty() && (!anythingPlaced || floatingBoxFullWidth <= bbox.getWidth())) {
                    childResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), layoutContext.getArea().getBBox().clone()), null, floatRendererAreas, wasParentsHeightClipped));
                }
                if (childWidthWasReplaced) {
                    if (childRendererHasOwnWidthProperty) {
                        childRenderer.setProperty(77, childWidth);
                    } else {
                        childRenderer.deleteOwnProperty(77);
                    }
                }
                minChildWidth = 0.0f;
                maxChildWidth = 0.0f;
                if (childResult instanceof MinMaxWidthLayoutResult) {
                    if (!childWidthWasReplaced) {
                        minChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMinWidth();
                    }
                    maxChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMaxWidth();
                    ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth + 1.0E-4f);
                    ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(maxChildWidth + 1.0E-4f);
                } else {
                    ((AbstractWidthHandler)widthHandler).updateMinChildWidth(kidMinMaxWidth.getMinWidth() + 1.0E-4f);
                    ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(kidMinMaxWidth.getMaxWidth() + 1.0E-4f);
                }
                if (childResult == null && !lineLayoutContext.isFloatOverflowedToNextPageWithNothing()) {
                    floatsOverflowedToNextLine.add(childRenderer);
                } else if (lineLayoutContext.isFloatOverflowedToNextPageWithNothing() || childResult.getStatus() == 3) {
                    floatsToNextPageSplitRenderers.put(childPos, null);
                    floatsToNextPageOverflowRenderers.add(childRenderer);
                    lineLayoutContext.setFloatOverflowedToNextPageWithNothing(true);
                } else if (childResult.getStatus() == 2) {
                    floatsPlaced = true;
                    if (childRenderer instanceof TextRenderer) {
                        LineRenderer[] split = this.splitNotFittingFloat(childPos, childResult);
                        IRenderer splitRenderer = childResult.getSplitRenderer();
                        if (splitRenderer instanceof TextRenderer) {
                            ((TextRenderer)splitRenderer).trimFirst();
                            ((TextRenderer)splitRenderer).trimLast();
                        }
                        splitRenderer.getOccupiedArea().getBBox().setWidth(layoutContext.getArea().getBBox().getWidth());
                        result = new LineLayoutResult(2, this.occupiedArea, split[0], split[1], null);
                        break;
                    }
                    floatsToNextPageSplitRenderers.put(childPos, childResult.getSplitRenderer());
                    floatsToNextPageOverflowRenderers.add(childResult.getOverflowRenderer());
                    this.adjustLineOnFloatPlaced(layoutBox, childPos, (FloatPropertyValue)((Object)kidFloatPropertyVal), childResult.getSplitRenderer().getOccupiedArea().getBBox());
                } else {
                    floatsPlaced = true;
                    if (childRenderer instanceof TextRenderer) {
                        ((TextRenderer)childRenderer).trimFirst();
                        ((TextRenderer)childRenderer).trimLast();
                    }
                    this.adjustLineOnFloatPlaced(layoutBox, childPos, (FloatPropertyValue)((Object)kidFloatPropertyVal), childRenderer.getOccupiedArea().getBBox());
                }
                ++childPos;
                if (anythingPlaced || childResult == null || childResult.getStatus() != 3 || !floatRendererAreas.isEmpty() || !this.isFirstOnRootArea()) continue;
                break;
            }
            MinMaxWidth childBlockMinMaxWidth = null;
            boolean isInlineBlockChild = this.isInlineBlockChild(childRenderer);
            if (!childWidthWasReplaced && isInlineBlockChild && childRenderer instanceof AbstractRenderer) {
                childBlockMinMaxWidth = ((AbstractRenderer)childRenderer).getMinMaxWidth();
                float childMaxWidth = childBlockMinMaxWidth.getMaxWidth() + 0.001f;
                float lineFullAvailableWidth = layoutContext.getArea().getBBox().getWidth() - lineLayoutContext.getTextIndent();
                if (childMaxWidth > bbox.getWidth() && bbox.getWidth() != lineFullAvailableWidth) {
                    childResult = new LineLayoutResult(3, null, null, childRenderer, childRenderer);
                } else {
                    if (bbox.getWidth() == lineFullAvailableWidth && childBlockMinMaxWidth.getMinWidth() > lineFullAvailableWidth) {
                        LoggerFactory.getLogger(LineRenderer.class).warn("Inline block element does not fit into parent element and will be clipped");
                        childRenderer.setProperty(26, true);
                    }
                    bbox.setWidth(Math.min(childMaxWidth, lineFullAvailableWidth));
                }
                childBlockMinMaxWidth.setChildrenMaxWidth(childBlockMinMaxWidth.getChildrenMaxWidth() + 0.001f);
                childBlockMinMaxWidth.setChildrenMinWidth(childBlockMinMaxWidth.getChildrenMinWidth() + 0.001f);
            }
            if (childResult == null) {
                if (!wasXOverflowChanged && childPos > 0) {
                    oldXOverflow = (OverflowPropertyValue)((Object)this.getProperty(103));
                    wasXOverflowChanged = true;
                    this.setProperty(103, (Object)OverflowPropertyValue.FIT);
                }
                if ((childResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox), wasParentsHeightClipped))) instanceof MinMaxWidthLayoutResult && null != childBlockMinMaxWidth) {
                    MinMaxWidth childResultMinMaxWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth();
                    childResultMinMaxWidth.setChildrenMaxWidth(childResultMinMaxWidth.getChildrenMaxWidth() + 0.001f);
                    childResultMinMaxWidth.setChildrenMinWidth(childResultMinMaxWidth.getChildrenMinWidth() + 0.001f);
                }
            }
            if (childWidthWasReplaced) {
                if (childRendererHasOwnWidthProperty) {
                    childRenderer.setProperty(77, childWidth);
                } else {
                    childRenderer.deleteOwnProperty(77);
                }
            }
            minChildWidth = 0.0f;
            maxChildWidth = 0.0f;
            if (childResult instanceof MinMaxWidthLayoutResult) {
                if (!childWidthWasReplaced) {
                    minChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMinWidth();
                }
                maxChildWidth = ((MinMaxWidthLayoutResult)childResult).getMinMaxWidth().getMaxWidth();
            } else if (childBlockMinMaxWidth != null) {
                minChildWidth = childBlockMinMaxWidth.getMinWidth();
                maxChildWidth = childBlockMinMaxWidth.getMaxWidth();
            }
            float childAscent = 0.0f;
            float childDescent = 0.0f;
            if (childRenderer instanceof ILeafElementRenderer && childResult.getStatus() != 3) {
                childAscent = ((ILeafElementRenderer)childRenderer).getAscent();
                childDescent = ((ILeafElementRenderer)childRenderer).getDescent();
            } else if (isInlineBlockChild && childResult.getStatus() != 3) {
                if (childRenderer instanceof AbstractRenderer) {
                    Float yLine = ((AbstractRenderer)childRenderer).getLastYLineRecursively();
                    if (yLine == null) {
                        childAscent = childRenderer.getOccupiedArea().getBBox().getHeight();
                    } else {
                        childAscent = childRenderer.getOccupiedArea().getBBox().getTop() - yLine.floatValue();
                        childDescent = -(yLine.floatValue() - childRenderer.getOccupiedArea().getBBox().getBottom());
                    }
                } else {
                    childAscent = childRenderer.getOccupiedArea().getBBox().getHeight();
                }
            }
            this.maxAscent = Math.max(this.maxAscent, childAscent);
            if (childRenderer instanceof TextRenderer) {
                this.maxTextAscent = Math.max(this.maxTextAscent, childAscent);
            } else if (!isChildFloating) {
                this.maxBlockAscent = Math.max(this.maxBlockAscent, childAscent);
            }
            this.maxDescent = Math.min(this.maxDescent, childDescent);
            if (childRenderer instanceof TextRenderer) {
                this.maxTextDescent = Math.min(this.maxTextDescent, childDescent);
            } else if (!isChildFloating) {
                this.maxBlockDescent = Math.min(this.maxBlockDescent, childDescent);
            }
            float maxHeight = this.maxAscent - this.maxDescent;
            boolean newLineOccurred = childResult instanceof TextLayoutResult && ((TextLayoutResult)childResult).isSplitForcedByNewline();
            boolean bl2 = shouldBreakLayouting = childResult.getStatus() != 1 || newLineOccurred;
            if (hangingTabStop != null && (TabAlignment.LEFT == hangingTabStop.getTabAlignment() || shouldBreakLayouting || this.childRenderers.size() - 1 == childPos || this.childRenderers.get(childPos + 1) instanceof TabRenderer)) {
                IRenderer tabRenderer = (IRenderer)this.childRenderers.get(lastTabIndex);
                ArrayList<IRenderer> affectedRenderers = new ArrayList<IRenderer>();
                affectedRenderers.addAll(this.childRenderers.subList(lastTabIndex + 1, childPos + 1));
                float tabWidth = this.calculateTab(layoutBox, curWidth, hangingTabStop, affectedRenderers, tabRenderer);
                tabRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), bbox), wasParentsHeightClipped));
                float sumOfAffectedRendererWidths = 0.0f;
                for (IRenderer renderer : affectedRenderers) {
                    renderer.getOccupiedArea().getBBox().moveRight(tabWidth + sumOfAffectedRendererWidths);
                    sumOfAffectedRendererWidths += renderer.getOccupiedArea().getBBox().getWidth();
                }
                if (childResult.getSplitRenderer() != null) {
                    childResult.getSplitRenderer().getOccupiedArea().getBBox().moveRight(tabWidth + sumOfAffectedRendererWidths - childResult.getSplitRenderer().getOccupiedArea().getBBox().getWidth());
                }
                float tabAndNextElemWidth = tabWidth + childResult.getOccupiedArea().getBBox().getWidth();
                curWidth = hangingTabStop.getTabAlignment() == TabAlignment.RIGHT && curWidth + tabAndNextElemWidth < hangingTabStop.getTabPosition() ? hangingTabStop.getTabPosition() : (curWidth += tabAndNextElemWidth);
                ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth);
                ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(tabWidth + maxChildWidth);
                hangingTabStop = null;
            } else if (null == hangingTabStop) {
                if (childResult.getOccupiedArea() != null && childResult.getOccupiedArea().getBBox() != null) {
                    curWidth += childResult.getOccupiedArea().getBBox().getWidth();
                }
                ((AbstractWidthHandler)widthHandler).updateMinChildWidth(minChildWidth);
                ((AbstractWidthHandler)widthHandler).updateMaxChildWidth(maxChildWidth);
            }
            this.occupiedArea.setBBox(new Rectangle(layoutBox.getX(), layoutBox.getY() + layoutBox.getHeight() - maxHeight, curWidth, maxHeight));
            if (shouldBreakLayouting) {
                IRenderer causeOfNothing;
                LineRenderer[] split = this.split();
                split[0].childRenderers = new ArrayList(this.childRenderers.subList(0, childPos));
                boolean wordWasSplitAndItWillFitOntoNextLine = false;
                if (childResult instanceof TextLayoutResult && ((TextLayoutResult)childResult).isWordHasBeenSplit()) {
                    if (wasXOverflowChanged) {
                        this.setProperty(103, (Object)oldXOverflow);
                    }
                    LayoutResult newLayoutResult = childRenderer.layout(new LayoutContext(new LayoutArea(layoutContext.getArea().getPageNumber(), layoutBox), wasParentsHeightClipped));
                    if (wasXOverflowChanged) {
                        this.setProperty(103, (Object)OverflowPropertyValue.FIT);
                    }
                    if (newLayoutResult instanceof TextLayoutResult && !((TextLayoutResult)newLayoutResult).isWordHasBeenSplit()) {
                        wordWasSplitAndItWillFitOntoNextLine = true;
                    }
                }
                if (wordWasSplitAndItWillFitOntoNextLine) {
                    split[1].childRenderers.add(childRenderer);
                    split[1].childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                } else {
                    boolean isInlineBlockAndFirstOnRootArea;
                    boolean forcePlacement = Boolean.TRUE.equals(this.getPropertyAsBoolean(26));
                    boolean bl3 = isInlineBlockAndFirstOnRootArea = isInlineBlockChild && this.isFirstOnRootArea();
                    if (childResult.getStatus() == 2 && (!isInlineBlockChild || forcePlacement || isInlineBlockAndFirstOnRootArea) || childResult.getStatus() == 1) {
                        split[0].addChild(childResult.getSplitRenderer());
                        anythingPlaced = true;
                    }
                    if (null != childResult.getOverflowRenderer()) {
                        if (isInlineBlockChild && !forcePlacement && !isInlineBlockAndFirstOnRootArea) {
                            split[1].childRenderers.add(childRenderer);
                        } else if (isInlineBlockChild && childResult.getOverflowRenderer().getChildRenderers().size() == 0) {
                            LoggerFactory.getLogger(LineRenderer.class).warn("Inline block element does not fit into parent element and will be clipped");
                        } else {
                            split[1].childRenderers.add(childResult.getOverflowRenderer());
                        }
                    }
                    split[1].childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
                }
                this.replaceSplitRendererKidFloats(floatsToNextPageSplitRenderers, split[0]);
                split[0].childRenderers.removeAll(floatsOverflowedToNextLine);
                split[1].childRenderers.addAll(0, floatsOverflowedToNextLine);
                if (split[1].childRenderers.size() == 0 && floatsToNextPageOverflowRenderers.isEmpty()) {
                    split[1] = null;
                }
                IRenderer iRenderer = causeOfNothing = childResult.getStatus() == 3 ? childResult.getCauseOfNothing() : childRenderer;
                if (split[1] == null) {
                    result = new LineLayoutResult(1, this.occupiedArea, split[0], split[1], causeOfNothing);
                } else {
                    result = anythingPlaced || floatsPlaced ? new LineLayoutResult(2, this.occupiedArea, split[0], split[1], causeOfNothing) : new LineLayoutResult(3, null, split[0], split[1], null);
                    ((LineLayoutResult)result).setFloatsOverflowedToNextPage(floatsToNextPageOverflowRenderers);
                }
                if (!newLineOccurred) break;
                ((LineLayoutResult)result).setSplitForcedByNewline(true);
                break;
            }
            anythingPlaced = true;
            ++childPos;
        }
        if (result == null) {
            boolean noOverflowedFloats;
            boolean bl = noOverflowedFloats = floatsOverflowedToNextLine.isEmpty() && floatsToNextPageOverflowRenderers.isEmpty();
            if ((anythingPlaced || floatsPlaced) && noOverflowedFloats || 0 == this.childRenderers.size()) {
                result = new LineLayoutResult(1, this.occupiedArea, null, null);
            } else if (noOverflowedFloats) {
                result = new LineLayoutResult(1, this.occupiedArea, null, null);
            } else if (anythingPlaced || floatsPlaced) {
                LineRenderer[] split = this.split();
                split[0].childRenderers.addAll(this.childRenderers.subList(0, childPos));
                this.replaceSplitRendererKidFloats(floatsToNextPageSplitRenderers, split[0]);
                split[0].childRenderers.removeAll(floatsOverflowedToNextLine);
                split[1].childRenderers.addAll(floatsOverflowedToNextLine);
                result = new LineLayoutResult(2, this.occupiedArea, split[0], split[1], null);
                ((LineLayoutResult)result).setFloatsOverflowedToNextPage(floatsToNextPageOverflowRenderers);
            } else {
                IRenderer causeOfNothing = floatsOverflowedToNextLine.isEmpty() ? (IRenderer)floatsToNextPageOverflowRenderers.get(0) : (IRenderer)floatsOverflowedToNextLine.get(0);
                result = new LineLayoutResult(3, null, null, this, causeOfNothing);
            }
        }
        if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI) {
            List<IRenderer> children = null;
            if (result.getStatus() == 2) {
                children = result.getSplitRenderer().getChildRenderers();
            } else if (result.getStatus() == 1) {
                children = this.getChildRenderers();
            }
            if (children != null) {
                int[] reorder;
                boolean newLineFound = false;
                ArrayList<RendererGlyph> lineGlyphs = new ArrayList<RendererGlyph>();
                HashMap insertAfter = new HashMap();
                ArrayList<IRenderer> starterNonTextRenderers = new ArrayList<IRenderer>();
                TextRenderer lastTextRenderer = null;
                for (IRenderer child : children) {
                    if (newLineFound) break;
                    if (child instanceof TextRenderer) {
                        GlyphLine childLine = ((TextRenderer)child).line;
                        for (int i = childLine.start; i < childLine.end; ++i) {
                            if (TextUtil.isNewLine((Glyph)childLine.get(i))) {
                                newLineFound = true;
                                break;
                            }
                            lineGlyphs.add(new RendererGlyph(childLine.get(i), (TextRenderer)child));
                        }
                        lastTextRenderer = (TextRenderer)child;
                        continue;
                    }
                    if (lastTextRenderer != null) {
                        if (!insertAfter.containsKey(lastTextRenderer)) {
                            insertAfter.put(lastTextRenderer, new ArrayList());
                        }
                        ((List)insertAfter.get(lastTextRenderer)).add(child);
                        continue;
                    }
                    starterNonTextRenderers.add(child);
                }
                byte[] lineLevels = new byte[lineGlyphs.size()];
                if (this.levels != null) {
                    System.arraycopy(this.levels, 0, lineLevels, 0, lineGlyphs.size());
                }
                if ((reorder = TypographyUtils.reorderLine(lineGlyphs, lineLevels, this.levels)) != null) {
                    children.clear();
                    int pos = 0;
                    int initialPos = 0;
                    boolean reversed = false;
                    int offset = 0;
                    for (IRenderer child : starterNonTextRenderers) {
                        children.add(child);
                    }
                    while (pos < lineGlyphs.size()) {
                        TextRenderer renderer = ((RendererGlyph)lineGlyphs.get((int)pos)).renderer;
                        TextRenderer newRenderer = new TextRenderer(renderer).removeReversedRanges();
                        children.add(newRenderer);
                        if (insertAfter.containsKey(renderer)) {
                            children.addAll((Collection)insertAfter.get(renderer));
                            insertAfter.remove(renderer);
                        }
                        newRenderer.line = new GlyphLine(newRenderer.line);
                        ArrayList<Glyph> replacementGlyphs = new ArrayList<Glyph>();
                        while (pos < lineGlyphs.size() && ((RendererGlyph)lineGlyphs.get((int)pos)).renderer == renderer) {
                            if (pos + 1 < lineGlyphs.size()) {
                                if (reorder[pos] == reorder[pos + 1] + 1 && !TextUtil.isSpaceOrWhitespace((Glyph)((RendererGlyph)lineGlyphs.get((int)(pos + 1))).glyph) && !TextUtil.isSpaceOrWhitespace((Glyph)((RendererGlyph)lineGlyphs.get((int)pos)).glyph)) {
                                    reversed = true;
                                } else {
                                    if (reversed) {
                                        List<int[]> reversedRange = newRenderer.initReversedRanges();
                                        reversedRange.add(new int[]{initialPos - offset, pos - offset});
                                        reversed = false;
                                    }
                                    initialPos = pos + 1;
                                }
                            }
                            replacementGlyphs.add(((RendererGlyph)lineGlyphs.get((int)pos)).glyph);
                            ++pos;
                        }
                        if (reversed) {
                            List<int[]> reversedRange = newRenderer.initReversedRanges();
                            reversedRange.add(new int[]{initialPos - offset, pos - 1 - offset});
                            reversed = false;
                            initialPos = pos;
                        }
                        offset = initialPos;
                        newRenderer.line.setGlyphs(replacementGlyphs);
                    }
                    float currentXPos = this.occupiedArea.getBBox().getLeft();
                    for (IRenderer child : children) {
                        float currentWidth;
                        if (child instanceof TextRenderer) {
                            Logger logger;
                            currentWidth = ((TextRenderer)child).calculateLineWidth();
                            UnitValue[] margins = ((TextRenderer)child).getMargins();
                            if (!margins[1].isPointValue()) {
                                logger = LoggerFactory.getLogger(LineRenderer.class);
                                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{45}));
                            }
                            if (!margins[3].isPointValue()) {
                                logger = LoggerFactory.getLogger(LineRenderer.class);
                                logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{44}));
                            }
                            ((TextRenderer)child).occupiedArea.getBBox().setX(currentXPos).setWidth(currentWidth += margins[1].getValue() + margins[3].getValue());
                        } else {
                            currentWidth = child.getOccupiedArea().getBBox().getWidth();
                            if (child instanceof AbstractRenderer) {
                                child.move(currentXPos - child.getOccupiedArea().getBBox().getX(), 0.0f);
                            } else {
                                child.getOccupiedArea().getBBox().setX(currentXPos);
                            }
                        }
                        currentXPos += currentWidth;
                    }
                }
                if (result.getStatus() == 2) {
                    LineRenderer overflow = (LineRenderer)result.getOverflowRenderer();
                    if (this.levels != null) {
                        overflow.levels = new byte[this.levels.length - lineLevels.length];
                        System.arraycopy(this.levels, lineLevels.length, overflow.levels, 0, overflow.levels.length);
                        if (overflow.levels.length == 0) {
                            overflow.levels = null;
                        }
                    }
                }
            }
        }
        LineRenderer lineRenderer = processed = result.getStatus() == 1 ? this : (LineRenderer)result.getSplitRenderer();
        if (anythingPlaced || floatsPlaced) {
            processed.adjustChildrenYLine().trimLast();
            ((MinMaxWidthLayoutResult)result).setMinMaxWidth(minMaxWidth);
        }
        if (wasXOverflowChanged) {
            this.setProperty(103, (Object)oldXOverflow);
            if (null != result.getSplitRenderer()) {
                result.getSplitRenderer().setProperty(103, (Object)oldXOverflow);
            }
            if (null != result.getOverflowRenderer()) {
                result.getOverflowRenderer().setProperty(103, (Object)oldXOverflow);
            }
        }
        return result;
    }

    public float getMaxAscent() {
        return this.maxAscent;
    }

    public float getMaxDescent() {
        return this.maxDescent;
    }

    public float getYLine() {
        return this.occupiedArea.getBBox().getY() - this.maxDescent;
    }

    public float getLeadingValue(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return Math.max(leading.getValue(), this.maxBlockAscent - this.maxBlockDescent);
            }
            case 2: {
                return this.getTopLeadingIndent(leading) + this.getBottomLeadingIndent(leading);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public IRenderer getNextRenderer() {
        return new LineRenderer();
    }

    @Override
    protected Float getFirstYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    @Override
    protected Float getLastYLineRecursively() {
        return Float.valueOf(this.getYLine());
    }

    public void justify(float width) {
        int baseCharsCount;
        int numberOfSpaces;
        float ratio = this.getPropertyAsFloat(61).floatValue();
        IRenderer lastChildRenderer = this.getLastNonFloatChildRenderer();
        if (lastChildRenderer == null) {
            return;
        }
        float freeWidth = this.occupiedArea.getBBox().getX() + width - lastChildRenderer.getOccupiedArea().getBBox().getX() - lastChildRenderer.getOccupiedArea().getBBox().getWidth();
        float baseFactor = freeWidth / (ratio * (float)(numberOfSpaces = this.getNumberOfSpaces()) + (1.0f - ratio) * (float)((baseCharsCount = this.baseCharactersCount()) - 1));
        if (Float.isInfinite(baseFactor)) {
            baseFactor = 0.0f;
        }
        float wordSpacing = ratio * baseFactor;
        float characterSpacing = (1.0f - ratio) * baseFactor;
        float lastRightPos = this.occupiedArea.getBBox().getX();
        for (IRenderer child : this.childRenderers) {
            if (FloatingHelper.isRendererFloating(child)) continue;
            float childX = child.getOccupiedArea().getBBox().getX();
            child.move(lastRightPos - childX, 0.0f);
            childX = lastRightPos;
            if (child instanceof TextRenderer) {
                float childHSCale = ((TextRenderer)child).getPropertyAsFloat(29, Float.valueOf(1.0f)).floatValue();
                child.setProperty(15, Float.valueOf(characterSpacing / childHSCale));
                child.setProperty(78, Float.valueOf(wordSpacing / childHSCale));
                boolean isLastTextRenderer = child == lastChildRenderer;
                float widthAddition = (float)(isLastTextRenderer ? ((TextRenderer)child).lineLength() - 1 : ((TextRenderer)child).lineLength()) * characterSpacing + wordSpacing * (float)((TextRenderer)child).getNumberOfSpaces();
                child.getOccupiedArea().getBBox().setWidth(child.getOccupiedArea().getBBox().getWidth() + widthAddition);
            }
            lastRightPos = childX + child.getOccupiedArea().getBBox().getWidth();
        }
        this.getOccupiedArea().getBBox().setWidth(width);
    }

    protected int getNumberOfSpaces() {
        int spaces = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer) || FloatingHelper.isRendererFloating(child)) continue;
            spaces += ((TextRenderer)child).getNumberOfSpaces();
        }
        return spaces;
    }

    protected int length() {
        int length = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer) || FloatingHelper.isRendererFloating(child)) continue;
            length += ((TextRenderer)child).lineLength();
        }
        return length;
    }

    protected int baseCharactersCount() {
        int count = 0;
        for (IRenderer child : this.childRenderers) {
            if (!(child instanceof TextRenderer) || FloatingHelper.isRendererFloating(child)) continue;
            count += ((TextRenderer)child).baseCharactersCount();
        }
        return count;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (IRenderer renderer : this.childRenderers) {
            sb.append(renderer.toString());
        }
        return sb.toString();
    }

    protected LineRenderer createSplitRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer createOverflowRenderer() {
        return (LineRenderer)this.getNextRenderer();
    }

    protected LineRenderer[] split() {
        LineRenderer splitRenderer = this.createSplitRenderer();
        splitRenderer.occupiedArea = this.occupiedArea.clone();
        splitRenderer.parent = this.parent;
        splitRenderer.maxAscent = this.maxAscent;
        splitRenderer.maxDescent = this.maxDescent;
        splitRenderer.maxTextAscent = this.maxTextAscent;
        splitRenderer.maxTextDescent = this.maxTextDescent;
        splitRenderer.maxBlockAscent = this.maxBlockAscent;
        splitRenderer.maxBlockDescent = this.maxBlockDescent;
        splitRenderer.levels = this.levels;
        splitRenderer.addAllProperties(this.getOwnProperties());
        LineRenderer overflowRenderer = this.createOverflowRenderer();
        overflowRenderer.parent = this.parent;
        overflowRenderer.addAllProperties(this.getOwnProperties());
        return new LineRenderer[]{splitRenderer, overflowRenderer};
    }

    protected LineRenderer adjustChildrenYLine() {
        float actualYLine = this.occupiedArea.getBBox().getY() + this.occupiedArea.getBBox().getHeight() - this.maxAscent;
        for (IRenderer renderer : this.childRenderers) {
            if (FloatingHelper.isRendererFloating(renderer)) continue;
            if (renderer instanceof ILeafElementRenderer) {
                float descent = ((ILeafElementRenderer)renderer).getDescent();
                renderer.move(0.0f, actualYLine - renderer.getOccupiedArea().getBBox().getBottom() + descent);
                continue;
            }
            Float yLine = this.isInlineBlockChild(renderer) && renderer instanceof AbstractRenderer ? ((AbstractRenderer)renderer).getLastYLineRecursively() : null;
            renderer.move(0.0f, actualYLine - (yLine == null ? renderer.getOccupiedArea().getBBox().getBottom() : yLine.floatValue()));
        }
        return this;
    }

    protected void applyLeading(float deltaY) {
        this.occupiedArea.getBBox().moveUp(deltaY);
        this.occupiedArea.getBBox().decreaseHeight(deltaY);
        for (IRenderer child : this.childRenderers) {
            if (FloatingHelper.isRendererFloating(child)) continue;
            child.move(0.0f, deltaY);
        }
    }

    protected LineRenderer trimLast() {
        int lastIndex = this.childRenderers.size();
        IRenderer lastRenderer = null;
        while (--lastIndex >= 0 && FloatingHelper.isRendererFloating(lastRenderer = (IRenderer)this.childRenderers.get(lastIndex))) {
        }
        if (lastRenderer instanceof TextRenderer && lastIndex >= 0) {
            float trimmedSpace = ((TextRenderer)lastRenderer).trimLast();
            this.occupiedArea.getBBox().setWidth(this.occupiedArea.getBBox().getWidth() - trimmedSpace);
        }
        return this;
    }

    public boolean containsImage() {
        for (IRenderer renderer : this.childRenderers) {
            if (!(renderer instanceof ImageRenderer)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected MinMaxWidth getMinMaxWidth() {
        LineLayoutResult result = (LineLayoutResult)this.layout(new LayoutContext(new LayoutArea(1, new Rectangle(MinMaxWidthUtils.getInfWidth(), 1000000.0f))));
        return result.getMinMaxWidth();
    }

    float getTopLeadingIndent(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return (Math.max(leading.getValue(), this.maxBlockAscent - this.maxBlockDescent) - this.occupiedArea.getBBox().getHeight()) / 2.0f;
            }
            case 2: {
                UnitValue fontSize = this.getProperty(24, UnitValue.createPointValue(0.0f));
                if (!fontSize.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(LineRenderer.class);
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                float textAscent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && Math.abs(this.maxAscent) + Math.abs(this.maxDescent) != 0.0f && !this.containsImage() ? fontSize.getValue() * 0.8f : this.maxTextAscent;
                float textDescent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && Math.abs(this.maxAscent) + Math.abs(this.maxDescent) != 0.0f && !this.containsImage() ? -fontSize.getValue() * 0.2f : this.maxTextDescent;
                return Math.max(textAscent + (textAscent - textDescent) * (leading.getValue() - 1.0f) / 2.0f, this.maxBlockAscent) - this.maxAscent;
            }
        }
        throw new IllegalStateException();
    }

    float getBottomLeadingIndent(Leading leading) {
        switch (leading.getType()) {
            case 1: {
                return (Math.max(leading.getValue(), this.maxBlockAscent - this.maxBlockDescent) - this.occupiedArea.getBBox().getHeight()) / 2.0f;
            }
            case 2: {
                UnitValue fontSize = this.getProperty(24, UnitValue.createPointValue(0.0f));
                if (!fontSize.isPointValue()) {
                    Logger logger = LoggerFactory.getLogger(LineRenderer.class);
                    logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
                }
                float textAscent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && !this.containsImage() ? fontSize.getValue() * 0.8f : this.maxTextAscent;
                float textDescent = this.maxTextAscent == 0.0f && this.maxTextDescent == 0.0f && !this.containsImage() ? -fontSize.getValue() * 0.2f : this.maxTextDescent;
                return Math.max(-textDescent + (textAscent - textDescent) * (leading.getValue() - 1.0f) / 2.0f, -this.maxBlockDescent) + this.maxDescent;
            }
        }
        throw new IllegalStateException();
    }

    private LineRenderer[] splitNotFittingFloat(int childPos, LayoutResult childResult) {
        LineRenderer[] split = this.split();
        split[0].childRenderers.addAll(this.childRenderers.subList(0, childPos));
        split[0].childRenderers.add(childResult.getSplitRenderer());
        split[1].childRenderers.add(childResult.getOverflowRenderer());
        split[1].childRenderers.addAll(this.childRenderers.subList(childPos + 1, this.childRenderers.size()));
        return split;
    }

    private void adjustLineOnFloatPlaced(Rectangle layoutBox, int childPos, FloatPropertyValue kidFloatPropertyVal, Rectangle justPlacedFloatBox) {
        if (justPlacedFloatBox.getBottom() >= layoutBox.getTop() || justPlacedFloatBox.getTop() < layoutBox.getTop()) {
            return;
        }
        boolean ltr = true;
        float floatWidth = justPlacedFloatBox.getWidth();
        if (kidFloatPropertyVal.equals((Object)FloatPropertyValue.LEFT)) {
            layoutBox.setWidth(layoutBox.getWidth() - floatWidth).moveRight(floatWidth);
            this.occupiedArea.getBBox().moveRight(floatWidth);
            if (ltr) {
                for (int i = 0; i < childPos; ++i) {
                    IRenderer prevChild = (IRenderer)this.childRenderers.get(i);
                    if (FloatingHelper.isRendererFloating(prevChild)) continue;
                    prevChild.move(floatWidth, 0.0f);
                }
            }
        } else {
            layoutBox.setWidth(layoutBox.getWidth() - floatWidth);
            if (!ltr) {
                // empty if block
            }
        }
    }

    private void replaceSplitRendererKidFloats(Map<Integer, IRenderer> floatsToNextPageSplitRenderers, LineRenderer splitRenderer) {
        for (Map.Entry<Integer, IRenderer> splitFloat : floatsToNextPageSplitRenderers.entrySet()) {
            if (splitFloat.getValue() != null) {
                splitRenderer.childRenderers.set(splitFloat.getKey(), splitFloat.getValue());
                continue;
            }
            splitRenderer.childRenderers.set(splitFloat.getKey(), null);
        }
        for (int i = splitRenderer.getChildRenderers().size() - 1; i >= 0; --i) {
            if (splitRenderer.getChildRenderers().get(i) != null) continue;
            splitRenderer.getChildRenderers().remove(i);
        }
    }

    private IRenderer getLastNonFloatChildRenderer() {
        for (int i = this.childRenderers.size() - 1; i >= 0; --i) {
            if (FloatingHelper.isRendererFloating((IRenderer)this.childRenderers.get(i))) continue;
            return (IRenderer)this.childRenderers.get(i);
        }
        return null;
    }

    private TabStop getNextTabStop(float curWidth) {
        NavigableMap tabStops = (NavigableMap)this.getProperty(69);
        Map.Entry nextTabStopEntry = null;
        TabStop nextTabStop = null;
        if (tabStops != null) {
            nextTabStopEntry = tabStops.higherEntry(Float.valueOf(curWidth));
        }
        if (nextTabStopEntry != null) {
            nextTabStop = (TabStop)nextTabStopEntry.getValue();
        }
        return nextTabStop;
    }

    private TabStop calculateTab(IRenderer childRenderer, float curWidth, float lineWidth) {
        TabStop nextTabStop = this.getNextTabStop(curWidth);
        if (nextTabStop == null) {
            this.processDefaultTab(childRenderer, curWidth, lineWidth);
            return null;
        }
        childRenderer.setProperty(68, nextTabStop.getTabLeader());
        childRenderer.setProperty(77, UnitValue.createPointValue(nextTabStop.getTabPosition() - curWidth));
        childRenderer.setProperty(85, UnitValue.createPointValue(this.maxAscent - this.maxDescent));
        if (nextTabStop.getTabAlignment() == TabAlignment.LEFT) {
            return null;
        }
        return nextTabStop;
    }

    private float calculateTab(Rectangle layoutBox, float curWidth, TabStop tabStop, List<IRenderer> affectedRenderers, IRenderer tabRenderer) {
        float sumOfAffectedRendererWidths = 0.0f;
        for (IRenderer renderer : affectedRenderers) {
            sumOfAffectedRendererWidths += renderer.getOccupiedArea().getBBox().getWidth();
        }
        float tabWidth = 0.0f;
        switch (tabStop.getTabAlignment()) {
            case RIGHT: {
                tabWidth = tabStop.getTabPosition() - curWidth - sumOfAffectedRendererWidths;
                break;
            }
            case CENTER: {
                tabWidth = tabStop.getTabPosition() - curWidth - sumOfAffectedRendererWidths / 2.0f;
                break;
            }
            case ANCHOR: {
                IRenderer renderer;
                float anchorPosition = -1.0f;
                float processedRenderersWidth = 0.0f;
                Iterator<IRenderer> iterator = affectedRenderers.iterator();
                while (iterator.hasNext() && -1.0f == (anchorPosition = ((TextRenderer)(renderer = iterator.next())).getTabAnchorCharacterPosition())) {
                    processedRenderersWidth += renderer.getOccupiedArea().getBBox().getWidth();
                }
                if (anchorPosition == -1.0f) {
                    anchorPosition = 0.0f;
                }
                tabWidth = tabStop.getTabPosition() - curWidth - anchorPosition - processedRenderersWidth;
            }
        }
        if (tabWidth < 0.0f) {
            tabWidth = 0.0f;
        }
        if (curWidth + tabWidth + sumOfAffectedRendererWidths > layoutBox.getWidth()) {
            tabWidth -= curWidth + sumOfAffectedRendererWidths + tabWidth - layoutBox.getWidth();
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth));
        tabRenderer.setProperty(85, UnitValue.createPointValue(this.maxAscent - this.maxDescent));
        return tabWidth;
    }

    private void processDefaultTab(IRenderer tabRenderer, float curWidth, float lineWidth) {
        Float tabDefault = this.getPropertyAsFloat(67);
        Float tabWidth = Float.valueOf(tabDefault.floatValue() - curWidth % tabDefault.floatValue());
        if (curWidth + tabWidth.floatValue() > lineWidth) {
            tabWidth = Float.valueOf(lineWidth - curWidth);
        }
        tabRenderer.setProperty(77, UnitValue.createPointValue(tabWidth.floatValue()));
        tabRenderer.setProperty(85, UnitValue.createPointValue(this.maxAscent - this.maxDescent));
    }

    private void updateChildrenParent() {
        for (IRenderer renderer : this.childRenderers) {
            renderer.setParent(this);
        }
    }

    private int trimFirst() {
        int totalNumberOfTrimmedGlyphs = 0;
        for (IRenderer renderer : this.childRenderers) {
            if (FloatingHelper.isRendererFloating(renderer)) continue;
            if (!(renderer instanceof TextRenderer)) break;
            TextRenderer textRenderer = (TextRenderer)renderer;
            GlyphLine currentText = textRenderer.getText();
            if (currentText != null) {
                int prevTextStart = currentText.start;
                textRenderer.trimFirst();
                int numOfTrimmedGlyphs = textRenderer.getText().start - prevTextStart;
                totalNumberOfTrimmedGlyphs += numOfTrimmedGlyphs;
            }
            if (textRenderer.length() <= 0) continue;
            break;
        }
        return totalNumberOfTrimmedGlyphs;
    }

    private BaseDirection applyOtf() {
        BaseDirection baseDirection = (BaseDirection)((Object)this.getProperty(7));
        for (IRenderer renderer : this.childRenderers) {
            if (!(renderer instanceof TextRenderer)) continue;
            ((TextRenderer)renderer).applyOtf();
            if (baseDirection != null && baseDirection != BaseDirection.NO_BIDI) continue;
            baseDirection = (BaseDirection)((Object)renderer.getOwnProperty(7));
        }
        return baseDirection;
    }

    private void updateBidiLevels(int totalNumberOfTrimmedGlyphs, BaseDirection baseDirection) {
        if (totalNumberOfTrimmedGlyphs != 0 && this.levels != null) {
            this.levels = Arrays.copyOfRange(this.levels, totalNumberOfTrimmedGlyphs, this.levels.length);
        }
        ArrayList<Integer> unicodeIdsReorderingList = null;
        if (this.levels == null && baseDirection != null && baseDirection != BaseDirection.NO_BIDI) {
            unicodeIdsReorderingList = new ArrayList<Integer>();
            boolean newLineFound = false;
            block0: for (IRenderer child : this.childRenderers) {
                if (newLineFound) break;
                if (!(child instanceof TextRenderer)) continue;
                GlyphLine text = ((TextRenderer)child).getText();
                for (int i = text.start; i < text.end; ++i) {
                    Glyph glyph = text.get(i);
                    if (TextUtil.isNewLine((Glyph)glyph)) {
                        newLineFound = true;
                        continue block0;
                    }
                    int unicode = glyph.hasValidUnicode() ? glyph.getUnicode() : glyph.getUnicodeChars()[0];
                    unicodeIdsReorderingList.add(unicode);
                }
            }
            this.levels = unicodeIdsReorderingList.size() > 0 ? TypographyUtils.getBidiLevels(baseDirection, ArrayUtil.toIntArray(unicodeIdsReorderingList)) : null;
        }
    }

    private void resolveChildrenFonts() {
        ArrayList<IRenderer> newChildRenderers = new ArrayList<IRenderer>(this.childRenderers.size());
        boolean updateChildRendrers = false;
        for (IRenderer child : this.childRenderers) {
            if (child instanceof TextRenderer) {
                if (!((TextRenderer)child).resolveFonts(newChildRenderers)) continue;
                updateChildRendrers = true;
                continue;
            }
            newChildRenderers.add(child);
        }
        if (updateChildRendrers) {
            this.childRenderers = newChildRenderers;
        }
    }

    private float decreaseRelativeWidthByChildAdditionalWidth(IRenderer childRenderer, float normalizedChildWidth) {
        if (childRenderer instanceof AbstractRenderer) {
            Rectangle dummyRect = new Rectangle(normalizedChildWidth, 0.0f);
            ((AbstractRenderer)childRenderer).applyMargins(dummyRect, false);
            if (!LineRenderer.isBorderBoxSizing(childRenderer)) {
                ((AbstractRenderer)childRenderer).applyBorderBox(dummyRect, false);
                ((AbstractRenderer)childRenderer).applyPaddings(dummyRect, false);
            }
            normalizedChildWidth = dummyRect.getWidth();
        }
        return normalizedChildWidth;
    }

    private boolean isInlineBlockChild(IRenderer child) {
        return child instanceof BlockRenderer || child instanceof TableRenderer;
    }

    static class RendererGlyph {
        public Glyph glyph;
        public TextRenderer renderer;

        public RendererGlyph(Glyph glyph, TextRenderer textRenderer) {
            this.glyph = glyph;
            this.renderer = textRenderer;
        }
    }
}

