/*
 * Decompiled with CFR 0.152.
 */
package shade.okhttp3.internal.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import shade.jetbrains.annotations.NotNull;
import shade.kotlin.Metadata;
import shade.kotlin.jvm.JvmField;
import shade.kotlin.jvm.internal.DefaultConstructorMarker;
import shade.kotlin.jvm.internal.Intrinsics;
import shade.okio.Okio;
import shade.okio.Sink;
import shade.okio.Source;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0005H&J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H&J\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005H&\u0082\u0002\u0007\n\u0005\b\u0091F0\u0001\u00a8\u0006\u0015"}, d2={"Lshade/okhttp3/internal/io/FileSystem;", "", "appendingSink", "Lshade/okio/Sink;", "file", "Ljava/io/File;", "delete", "", "deleteContents", "directory", "exists", "", "rename", "from", "to", "sink", "size", "", "source", "Lshade/okio/Source;", "Companion", "okhttp"})
public interface FileSystem {
    @JvmField
    @NotNull
    public static final FileSystem SYSTEM;
    public static final Companion Companion;

    @NotNull
    public Source source(@NotNull File var1) throws FileNotFoundException;

    @NotNull
    public Sink sink(@NotNull File var1) throws FileNotFoundException;

    @NotNull
    public Sink appendingSink(@NotNull File var1) throws FileNotFoundException;

    public void delete(@NotNull File var1) throws IOException;

    public boolean exists(@NotNull File var1);

    public long size(@NotNull File var1);

    public void rename(@NotNull File var1, @NotNull File var2) throws IOException;

    public void deleteContents(@NotNull File var1) throws IOException;

    static {
        Companion = new Companion(null);
        SYSTEM = new FileSystem(){

            @NotNull
            public Source source(@NotNull File file) throws FileNotFoundException {
                Intrinsics.checkParameterIsNotNull(file, "file");
                return Okio.source(file);
            }

            @NotNull
            public Sink sink(@NotNull File file) throws FileNotFoundException {
                Sink sink2;
                Intrinsics.checkParameterIsNotNull(file, "file");
                try {
                    sink2 = Okio.sink$default(file, false, 1, null);
                }
                catch (FileNotFoundException _) {
                    file.getParentFile().mkdirs();
                    sink2 = Okio.sink$default(file, false, 1, null);
                }
                return sink2;
            }

            @NotNull
            public Sink appendingSink(@NotNull File file) throws FileNotFoundException {
                Sink sink2;
                Intrinsics.checkParameterIsNotNull(file, "file");
                try {
                    sink2 = Okio.appendingSink(file);
                }
                catch (FileNotFoundException _) {
                    file.getParentFile().mkdirs();
                    sink2 = Okio.appendingSink(file);
                }
                return sink2;
            }

            public void delete(@NotNull File file) throws IOException {
                Intrinsics.checkParameterIsNotNull(file, "file");
                if (!file.delete() && file.exists()) {
                    throw (Throwable)new IOException("failed to delete " + file);
                }
            }

            public boolean exists(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                return file.exists();
            }

            public long size(@NotNull File file) {
                Intrinsics.checkParameterIsNotNull(file, "file");
                return file.length();
            }

            public void rename(@NotNull File from, @NotNull File to) throws IOException {
                Intrinsics.checkParameterIsNotNull(from, "from");
                Intrinsics.checkParameterIsNotNull(to, "to");
                this.delete(to);
                if (!from.renameTo(to)) {
                    throw (Throwable)new IOException("failed to rename " + from + " to " + to);
                }
            }

            public void deleteContents(@NotNull File directory) throws IOException {
                File[] files;
                Intrinsics.checkParameterIsNotNull(directory, "directory");
                File[] fileArray = directory.listFiles();
                if (fileArray == null) {
                    throw (Throwable)new IOException("not a readable directory: " + directory);
                }
                File[] fileArray2 = files = fileArray;
                int n = fileArray2.length;
                for (int i = 0; i < n; ++i) {
                    File file;
                    File file2 = file = fileArray2[i];
                    Intrinsics.checkExpressionValueIsNotNull(file2, "file");
                    if (file2.isDirectory()) {
                        this.deleteContents(file);
                    }
                    if (file.delete()) continue;
                    throw (Throwable)new IOException("failed to delete " + file);
                }
            }

            @NotNull
            public String toString() {
                return "FileSystem.SYSTEM";
            }
        };
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00f8\u0001\u0000\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0001\u0082\u0002\u0007\n\u0005\b\u0091F0\u0001\u00a8\u0006\u0005"}, d2={"Lshade/okhttp3/internal/io/FileSystem$Companion;", "", "()V", "SYSTEM", "Lshade/okhttp3/internal/io/FileSystem;", "okhttp"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

