/*
 * Decompiled with CFR 0.152.
 */
package com.github.fakemongo.impl;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import com.mongodb.FongoDB;
import com.mongodb.FongoDBCollection;
import com.mongodb.util.JSON;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeObject;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapReduce {
    private static final Logger LOG = LoggerFactory.getLogger(MapReduce.class);
    private final FongoDB fongoDB;
    private final FongoDBCollection fongoDBCollection;
    private final String map;
    private final String reduce;
    private final String finalize;
    private final DBObject out;
    private final DBObject query;
    private final DBObject sort;
    private final int limit;

    public MapReduce(FongoDB fongoDB, FongoDBCollection coll, String map, String reduce, String finalize, DBObject out, DBObject query, DBObject sort, Number limit) {
        this.fongoDB = fongoDB;
        this.fongoDBCollection = coll;
        this.map = map;
        this.reduce = reduce;
        this.finalize = finalize;
        this.out = out;
        this.query = query;
        this.sort = sort;
        this.limit = limit == null ? 0 : limit.intValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBObject computeResult() {
        Outmode outmode = Outmode.valueFor(this.out);
        DBCollection coll = this.fongoDB.createCollection(outmode.collectionName(this.out), null);
        outmode.initCollection(coll);
        Context cx = Context.enter();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            List objects = this.fongoDBCollection.find(this.query).sort(this.sort).limit(this.limit).toArray();
            List<String> javascriptFunctions = this.constructJavascriptFunction(objects);
            for (String jsFunction : javascriptFunctions) {
                try {
                    cx.evaluateString((Scriptable)scope, jsFunction, "<map-reduce>", 0, null);
                }
                catch (RhinoException e) {
                    LOG.error("Exception running script {}", (Object)jsFunction, (Object)e);
                    this.fongoDB.notOkErrorResult(16722, "JavaScript execution failed: " + e.getMessage()).throwOnError();
                }
            }
            NativeArray outs = (NativeArray)scope.get("$$$fongoOuts$$$", (Scriptable)scope);
            int i = 0;
            while ((long)i < outs.getLength()) {
                NativeObject out = (NativeObject)outs.get(i, (Scriptable)outs);
                outmode.newResult(coll, this.getObject(out));
                ++i;
            }
            DBObject result = outmode.createResult(coll);
            LOG.debug("computeResult() : {}", (Object)result);
            DBObject dBObject = result;
            return dBObject;
        }
        finally {
            cx.exit();
        }
    }

    DBObject getObject(NativeObject no) {
        Object[] propIds;
        BasicDBObject ret = new BasicDBObject();
        for (Object propId : propIds = no.getIds()) {
            String key = Context.toString((Object)propId);
            Object value = NativeObject.getProperty((Scriptable)no, (String)key);
            if (value instanceof NativeObject) {
                ret.put(key, (Object)this.getObject((NativeObject)value));
                continue;
            }
            ret.put(key, value);
        }
        return ret;
    }

    private List<String> constructJavascriptFunction(List<DBObject> objects) {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder sb = new StringBuilder(80000);
        this.addMongoFunctions(sb);
        sb.append("var $$$fongoEmits$$$ = new Object();\n");
        sb.append("function emit(param1, param2) { if(typeof $$$fongoEmits$$$[param1] === 'undefined') { $$$fongoEmits$$$[param1] = new Array();}\n$$$fongoEmits$$$[param1][$$$fongoEmits$$$[param1].length] = param2;\n};\n");
        sb.append("var fongoMapFunction = ").append(this.map).append(";\n");
        sb.append("var $$$fongoVars$$$ = new Object();\n");
        for (DBObject object : objects) {
            String json = JSON.serialize((Object)object);
            sb.append("$$$fongoVars$$$ = ").append(json).append(";\n");
            sb.append("$$$fongoVars$$$['fongoExecute'] = fongoMapFunction;\n");
            sb.append("$$$fongoVars$$$.fongoExecute();\n");
            if (sb.length() <= 65535) continue;
            result.add(sb.toString());
            sb.setLength(0);
        }
        result.add(sb.toString());
        sb.setLength(0);
        sb.append("var reduce = ").append(this.reduce).append("\n");
        sb.append("var $$$fongoOuts$$$ = Array();\nfor(i in $$$fongoEmits$$$) {\n$$$fongoOuts$$$[$$$fongoOuts$$$.length] = { _id : i, value : reduce(i, $$$fongoEmits$$$[i]) };\n}\n");
        result.add(sb.toString());
        return result;
    }

    private void addMongoFunctions(StringBuilder construct) {
        construct.append("Array.sum = function(array) {\n    var a = 0;\n    for (var i = 0; i < array.length; i++) {\n        a = a + array[i];\n    }\n    return a;};\n");
    }

    private static enum Outmode {
        REPLACE{

            @Override
            public void initCollection(DBCollection coll) {
                coll.remove((DBObject)new BasicDBObject());
            }

            @Override
            public void newResult(DBCollection coll, DBObject result) {
                coll.insert(new DBObject[]{result});
            }
        }
        ,
        MERGE{

            @Override
            public void newResult(DBCollection coll, DBObject result) {
                coll.update((DBObject)new BasicDBObject("_id", result.get("_id")), result, true, false);
            }
        }
        ,
        REDUCE{

            @Override
            public void newResult(DBCollection coll, DBObject result) {
                throw new IllegalStateException();
            }
        }
        ,
        INLINE{

            @Override
            public void initCollection(DBCollection coll) {
                coll.remove((DBObject)new BasicDBObject());
            }

            @Override
            public void newResult(DBCollection coll, DBObject result) {
                coll.insert(new DBObject[]{result});
            }

            @Override
            public String collectionName(DBObject object) {
                return UUID.randomUUID().toString();
            }

            @Override
            public DBObject createResult(DBCollection coll) {
                BasicDBList list = new BasicDBList();
                list.addAll((Collection)coll.find().toArray());
                return list;
            }
        };


        public static Outmode valueFor(DBObject object) {
            for (Outmode outmode : Outmode.values()) {
                if (!object.containsField(outmode.name().toLowerCase())) continue;
                return outmode;
            }
            return null;
        }

        public String collectionName(DBObject object) {
            return (String)object.get(this.name().toLowerCase());
        }

        public void initCollection(DBCollection coll) {
        }

        public abstract void newResult(DBCollection var1, DBObject var2);

        public DBObject createResult(DBCollection coll) {
            BasicDBObject result = new BasicDBObject("collection", (Object)coll.getName()).append("db", (Object)coll.getDB().getName());
            return result;
        }
    }
}

