/*
 * Decompiled with CFR 0.152.
 */
package com.github.cloudyrock.mongock.driver.mongodb.sync.v4.changelogs;

import com.github.cloudyrock.mongock.migration.MongockLegacyMigration;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import io.changock.driver.api.entry.ChangeEntry;
import io.changock.driver.api.entry.ChangeEntryService;
import io.changock.driver.api.entry.ChangeState;
import io.changock.migration.api.annotations.NonLockGuarded;
import io.changock.migration.api.annotations.NonLockGuardedType;
import io.changock.migration.api.exception.ChangockException;
import io.changock.runner.core.builder.configuration.LegacyMigrationMappingFields;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.inject.Named;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyService {
    private static final Logger logger = LoggerFactory.getLogger(LegacyService.class);

    public void executeMigration(@NonLockGuarded(value={NonLockGuardedType.NONE}) @Named(value="legacy-migration") MongockLegacyMigration legacyMigration, MongoDatabase mongoDatabase, ChangeEntryService<ChangeEntry> changeEntryService) {
        int changesMigrated = 0;
        Integer changesCountExpectation = legacyMigration.getChangesCountExpectation();
        if (changesCountExpectation == null) {
            logger.warn("[legacy-migration] - There is no changes count expectation!");
        }
        try {
            this.validateLegacyMigration(legacyMigration);
            List<ChangeEntry> changesToMigrate = this.getOriginalMigrationAsChangeEntryList((MongoCollection<Document>)mongoDatabase.getCollection(legacyMigration.getCollectionName()), legacyMigration);
            for (ChangeEntry originalChange : changesToMigrate) {
                if (!changeEntryService.isAlreadyExecuted(originalChange.getChangeId(), originalChange.getAuthor())) {
                    this.logTracking(originalChange);
                    changeEntryService.save(originalChange);
                    this.logSuccessfullyTracked(originalChange);
                } else {
                    this.logAlreadyTracked(originalChange);
                }
                ++changesMigrated;
            }
            if (changesCountExpectation != null && changesCountExpectation != changesMigrated) {
                throw new ChangockException(String.format("[legacy-migration] - Expectation [%d changes migrated], but actual [%d changes migrated]", changesCountExpectation, changesMigrated));
            }
            logger.debug("[legacy-migration] - {} changes migrated", (Object)changesMigrated);
        }
        catch (ChangockException ex) {
            this.processException(legacyMigration.isFailFast(), ex);
        }
        catch (Exception ex) {
            this.processException(legacyMigration.isFailFast(), new ChangockException(ex));
        }
    }

    private void processException(boolean isFailFast, ChangockException ex) {
        if (isFailFast) {
            throw new ChangockException((Exception)((Object)ex));
        }
        logger.warn(ex.getMessage());
    }

    private List<ChangeEntry> getOriginalMigrationAsChangeEntryList(MongoCollection<Document> originalCollection, MongockLegacyMigration legacyMigration) {
        ArrayList<ChangeEntry> originalMigrations = new ArrayList<ChangeEntry>();
        LegacyMigrationMappingFields mappingFields = legacyMigration.getMappingFields();
        FindIterable docs = originalCollection.find();
        MongoCursor iteratorOriginalMigration = docs.iterator();
        String executionId = this.getExecutionId();
        while (iteratorOriginalMigration.hasNext()) {
            Document changeDocument = (Document)iteratorOriginalMigration.next();
            ChangeEntry change = new ChangeEntry(executionId, this.getDocumentStringValue(changeDocument, mappingFields.getChangeId()), this.getDocumentStringValue(changeDocument, mappingFields.getAuthor()), this.getDocumentDateValue(changeDocument, mappingFields.getTimestamp()), ChangeState.EXECUTED, this.getDocumentStringValue(changeDocument, mappingFields.getChangeLogClass()), this.getDocumentStringValue(changeDocument, mappingFields.getChangeSetMethod()), -1L, this.getMetadata(changeDocument, mappingFields.getMetadata()));
            originalMigrations.add(change);
        }
        return originalMigrations;
    }

    private Object getMetadata(Document changeDocument, String field) {
        HashMap<String, String> newMetadata = new HashMap<String, String>();
        newMetadata.put("migration-type", "legacy");
        String originalMetadata = field != null ? changeDocument.getString((Object)field) : null;
        if (originalMetadata != null) {
            newMetadata.put("original-metadata", originalMetadata);
        }
        return newMetadata;
    }

    private String getDocumentStringValue(Document changeDocument, String field) {
        return field != null ? changeDocument.getString((Object)field) : null;
    }

    private Date getDocumentDateValue(Document changeDocument, String field) {
        return field != null ? changeDocument.getDate((Object)field) : null;
    }

    private String getExecutionId() {
        return String.format("%s-%s-%d", "legacy_migration", LocalDateTime.now().toString(), new Random().nextInt(999));
    }

    private void validateLegacyMigration(MongockLegacyMigration legacyMigration) {
        if (legacyMigration == null || LegacyService.isEmpty(legacyMigration.getCollectionName()) || legacyMigration.getMappingFields() == null || LegacyService.isEmpty(legacyMigration.getMappingFields().getChangeId()) || LegacyService.isEmpty(legacyMigration.getMappingFields().getAuthor())) {
            throw new ChangockException("[legacy-migration] - wrong configured. Either is null, or doesn't contain collectionName or mapping fields are wrong");
        }
    }

    private static boolean isEmpty(String text) {
        return text == null || text.isEmpty();
    }

    private void logAlreadyTracked(ChangeEntry originalChange) {
        logger.debug("[legacy-migration] - Change[changeId: {} ][author: {} ] already tracked in Mongock changeLog collection", (Object)originalChange.getChangeId(), (Object)originalChange.getAuthor());
    }

    private void logSuccessfullyTracked(ChangeEntry originalChange) {
        logger.debug("[legacy-migration] - Change[changeId: {} ][author: {} ] tracked successfully", (Object)originalChange.getChangeId(), (Object)originalChange.getAuthor());
    }

    private void logTracking(ChangeEntry originalChange) {
        logger.debug("[legacy-migration] - Tracking change[changeId: {} ][author: {} ]...", (Object)originalChange.getChangeId(), (Object)originalChange.getAuthor());
    }
}

