/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.JSONUtils;
import com.esri.core.geometry.SpatialReferenceImpl;
import com.esri.core.geometry.SpatialReferenceSerializer;
import java.io.ObjectStreamException;
import java.io.Serializable;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;

public abstract class SpatialReference
implements Serializable {
    private static final long serialVersionUID = 2L;

    public static SpatialReference create(int wkid) {
        SpatialReferenceImpl spatRef = SpatialReferenceImpl.createImpl(wkid);
        return spatRef;
    }

    public static SpatialReference create(String wktext) {
        return SpatialReferenceImpl.createImpl(wktext);
    }

    boolean isLocal() {
        return false;
    }

    public static SpatialReference fromJson(JsonParser parser) throws Exception {
        int wkid = 0;
        String wkt = null;
        if (!JSONUtils.isObjectStart(parser)) {
            return null;
        }
        while (parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = parser.getCurrentName();
            parser.nextToken();
            if (parser.getCurrentToken() == JsonToken.VALUE_NULL) continue;
            if ("latestWkid".equals(fieldName)) {
                wkid = parser.getIntValue();
                continue;
            }
            if ("wkid".equals(fieldName)) {
                wkid = parser.getIntValue();
                continue;
            }
            if ("wkt".equals(fieldName)) {
                wkt = parser.getText();
                continue;
            }
            parser.skipChildren();
        }
        if (wkid > 0) {
            try {
                return SpatialReference.create(wkid);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (wkt != null && wkt.length() != 0) {
            return SpatialReference.create(wkt);
        }
        return null;
    }

    public abstract int getID();

    public abstract String getText();

    abstract int getOldID();

    abstract int getLatestID();

    public double getTolerance() {
        return this.getTolerance(0);
    }

    abstract double getTolerance(int var1);

    Object writeReplace() throws ObjectStreamException {
        SpatialReferenceSerializer srSerializer = new SpatialReferenceSerializer();
        srSerializer.setSpatialReferenceByValue(this);
        return srSerializer;
    }
}

