/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

class MathUtils {
    MathUtils() {
    }

    static double copySign(double x, double y) {
        return y >= 0.0 ? Math.abs(x) : -Math.abs(x);
    }

    static double FMod(double x, double y) {
        return x - Math.floor(x / y) * y;
    }

    static double round(double v) {
        return Math.floor(v + 0.5);
    }

    static final class KahanSummator {
        private double sum;
        private double compensation;
        private double startValue;

        KahanSummator(double startValue_) {
            this.startValue = startValue_;
            this.reset();
        }

        void reset() {
            this.sum = 0.0;
            this.compensation = 0.0;
        }

        void add(double v) {
            double y = v - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        void sub(double v) {
            this.add(-v);
        }

        void add(KahanSummator v) {
            double y = v.getResult() + v.compensation - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        void sub(KahanSummator v) {
            double y = -(v.getResult() - v.compensation) - this.compensation;
            double t = this.sum + y;
            double h = t - this.sum;
            this.compensation = h - y;
            this.sum = t;
        }

        double getResult() {
            return this.startValue + this.sum;
        }

        KahanSummator plusEquals(double v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(double v) {
            this.add(-v);
            return this;
        }

        KahanSummator plusEquals(KahanSummator v) {
            this.add(v);
            return this;
        }

        KahanSummator minusEquals(KahanSummator v) {
            this.sub(v);
            return this;
        }
    }
}

