/*
 Copyright 1995-2013 Esri

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.

 For additional information, contact:
 Environmental Systems Research Institute, Inc.
 Attn: Contracts Dept
 380 New York Street
 Redlands, California, USA 92373

 email: contracts@esri.com
 */

package com.esri.core.geometry;

import com.esri.core.geometry.Geometry.GeometryAccelerationDegree;

/**
 * A base class for simple relation operators.
 */
public abstract class OperatorSimpleRelation extends Operator {

	/**
	 * Performs the given relation operation between two geometries.
	 * 
	 * @return Returns True if the relation holds, False otherwise.
	 */
	public abstract boolean execute(Geometry inputGeom1, Geometry inputGeom2,
			SpatialReference sr, ProgressTracker progressTracker);

	@Override
	public boolean canAccelerateGeometry(Geometry geometry) {
		return RasterizedGeometry2D.canUseAccelerator(geometry);
	}
	
	@Override
	public boolean accelerateGeometry(Geometry geometry,
			SpatialReference spatialReference,
			GeometryAccelerationDegree accelDegree) {
		if (!canAccelerateGeometry(geometry))
			return false;

		double tol = spatialReference != null ? spatialReference
				.getTolerance(VertexDescription.Semantics.POSITION) : 0;
		boolean accelerated = ((MultiVertexGeometryImpl) geometry._getImpl())
				._buildQuadTreeAccelerator(accelDegree);
		accelerated |= ((MultiVertexGeometryImpl) geometry._getImpl())
				._buildRasterizedGeometryAccelerator(tol, accelDegree);
		return accelerated;
	}
}
