/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.globalaccelerator.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.globalaccelerator.model.transform.IpSetMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class IpSet
implements Serializable,
Cloneable,
StructuredPojo {
    private String ipFamily;
    private List<String> ipAddresses;

    public void setIpFamily(String ipFamily) {
        this.ipFamily = ipFamily;
    }

    public String getIpFamily() {
        return this.ipFamily;
    }

    public IpSet withIpFamily(String ipFamily) {
        this.setIpFamily(ipFamily);
        return this;
    }

    public List<String> getIpAddresses() {
        return this.ipAddresses;
    }

    public void setIpAddresses(Collection<String> ipAddresses) {
        if (ipAddresses == null) {
            this.ipAddresses = null;
            return;
        }
        this.ipAddresses = new ArrayList<String>(ipAddresses);
    }

    public IpSet withIpAddresses(String ... ipAddresses) {
        if (this.ipAddresses == null) {
            this.setIpAddresses(new ArrayList<String>(ipAddresses.length));
        }
        for (String ele : ipAddresses) {
            this.ipAddresses.add(ele);
        }
        return this;
    }

    public IpSet withIpAddresses(Collection<String> ipAddresses) {
        this.setIpAddresses(ipAddresses);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getIpFamily() != null) {
            sb.append("IpFamily: ").append(this.getIpFamily()).append(",");
        }
        if (this.getIpAddresses() != null) {
            sb.append("IpAddresses: ").append(this.getIpAddresses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IpSet)) {
            return false;
        }
        IpSet other = (IpSet)obj;
        if (other.getIpFamily() == null ^ this.getIpFamily() == null) {
            return false;
        }
        if (other.getIpFamily() != null && !other.getIpFamily().equals(this.getIpFamily())) {
            return false;
        }
        if (other.getIpAddresses() == null ^ this.getIpAddresses() == null) {
            return false;
        }
        return other.getIpAddresses() == null || other.getIpAddresses().equals(this.getIpAddresses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getIpFamily() == null ? 0 : this.getIpFamily().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddresses() == null ? 0 : this.getIpAddresses().hashCode());
        return hashCode;
    }

    public IpSet clone() {
        try {
            return (IpSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        IpSetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

