/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.frauddetector.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.frauddetector.model.EventIngestion;
import com.amazonaws.services.frauddetector.model.IngestedEventStatistics;
import com.amazonaws.services.frauddetector.model.transform.EventTypeMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class EventType
implements Serializable,
Cloneable,
StructuredPojo {
    private String name;
    private String description;
    private List<String> eventVariables;
    private List<String> labels;
    private List<String> entityTypes;
    private String eventIngestion;
    private IngestedEventStatistics ingestedEventStatistics;
    private String lastUpdatedTime;
    private String createdTime;
    private String arn;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EventType withName(String name) {
        this.setName(name);
        return this;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public EventType withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public List<String> getEventVariables() {
        return this.eventVariables;
    }

    public void setEventVariables(Collection<String> eventVariables) {
        if (eventVariables == null) {
            this.eventVariables = null;
            return;
        }
        this.eventVariables = new ArrayList<String>(eventVariables);
    }

    public EventType withEventVariables(String ... eventVariables) {
        if (this.eventVariables == null) {
            this.setEventVariables(new ArrayList<String>(eventVariables.length));
        }
        for (String ele : eventVariables) {
            this.eventVariables.add(ele);
        }
        return this;
    }

    public EventType withEventVariables(Collection<String> eventVariables) {
        this.setEventVariables(eventVariables);
        return this;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public void setLabels(Collection<String> labels) {
        if (labels == null) {
            this.labels = null;
            return;
        }
        this.labels = new ArrayList<String>(labels);
    }

    public EventType withLabels(String ... labels) {
        if (this.labels == null) {
            this.setLabels(new ArrayList<String>(labels.length));
        }
        for (String ele : labels) {
            this.labels.add(ele);
        }
        return this;
    }

    public EventType withLabels(Collection<String> labels) {
        this.setLabels(labels);
        return this;
    }

    public List<String> getEntityTypes() {
        return this.entityTypes;
    }

    public void setEntityTypes(Collection<String> entityTypes) {
        if (entityTypes == null) {
            this.entityTypes = null;
            return;
        }
        this.entityTypes = new ArrayList<String>(entityTypes);
    }

    public EventType withEntityTypes(String ... entityTypes) {
        if (this.entityTypes == null) {
            this.setEntityTypes(new ArrayList<String>(entityTypes.length));
        }
        for (String ele : entityTypes) {
            this.entityTypes.add(ele);
        }
        return this;
    }

    public EventType withEntityTypes(Collection<String> entityTypes) {
        this.setEntityTypes(entityTypes);
        return this;
    }

    public void setEventIngestion(String eventIngestion) {
        this.eventIngestion = eventIngestion;
    }

    public String getEventIngestion() {
        return this.eventIngestion;
    }

    public EventType withEventIngestion(String eventIngestion) {
        this.setEventIngestion(eventIngestion);
        return this;
    }

    public EventType withEventIngestion(EventIngestion eventIngestion) {
        this.eventIngestion = eventIngestion.toString();
        return this;
    }

    public void setIngestedEventStatistics(IngestedEventStatistics ingestedEventStatistics) {
        this.ingestedEventStatistics = ingestedEventStatistics;
    }

    public IngestedEventStatistics getIngestedEventStatistics() {
        return this.ingestedEventStatistics;
    }

    public EventType withIngestedEventStatistics(IngestedEventStatistics ingestedEventStatistics) {
        this.setIngestedEventStatistics(ingestedEventStatistics);
        return this;
    }

    public void setLastUpdatedTime(String lastUpdatedTime) {
        this.lastUpdatedTime = lastUpdatedTime;
    }

    public String getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public EventType withLastUpdatedTime(String lastUpdatedTime) {
        this.setLastUpdatedTime(lastUpdatedTime);
        return this;
    }

    public void setCreatedTime(String createdTime) {
        this.createdTime = createdTime;
    }

    public String getCreatedTime() {
        return this.createdTime;
    }

    public EventType withCreatedTime(String createdTime) {
        this.setCreatedTime(createdTime);
        return this;
    }

    public void setArn(String arn) {
        this.arn = arn;
    }

    public String getArn() {
        return this.arn;
    }

    public EventType withArn(String arn) {
        this.setArn(arn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getEventVariables() != null) {
            sb.append("EventVariables: ").append(this.getEventVariables()).append(",");
        }
        if (this.getLabels() != null) {
            sb.append("Labels: ").append(this.getLabels()).append(",");
        }
        if (this.getEntityTypes() != null) {
            sb.append("EntityTypes: ").append(this.getEntityTypes()).append(",");
        }
        if (this.getEventIngestion() != null) {
            sb.append("EventIngestion: ").append(this.getEventIngestion()).append(",");
        }
        if (this.getIngestedEventStatistics() != null) {
            sb.append("IngestedEventStatistics: ").append(this.getIngestedEventStatistics()).append(",");
        }
        if (this.getLastUpdatedTime() != null) {
            sb.append("LastUpdatedTime: ").append(this.getLastUpdatedTime()).append(",");
        }
        if (this.getCreatedTime() != null) {
            sb.append("CreatedTime: ").append(this.getCreatedTime()).append(",");
        }
        if (this.getArn() != null) {
            sb.append("Arn: ").append(this.getArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EventType)) {
            return false;
        }
        EventType other = (EventType)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getEventVariables() == null ^ this.getEventVariables() == null) {
            return false;
        }
        if (other.getEventVariables() != null && !other.getEventVariables().equals(this.getEventVariables())) {
            return false;
        }
        if (other.getLabels() == null ^ this.getLabels() == null) {
            return false;
        }
        if (other.getLabels() != null && !other.getLabels().equals(this.getLabels())) {
            return false;
        }
        if (other.getEntityTypes() == null ^ this.getEntityTypes() == null) {
            return false;
        }
        if (other.getEntityTypes() != null && !other.getEntityTypes().equals(this.getEntityTypes())) {
            return false;
        }
        if (other.getEventIngestion() == null ^ this.getEventIngestion() == null) {
            return false;
        }
        if (other.getEventIngestion() != null && !other.getEventIngestion().equals(this.getEventIngestion())) {
            return false;
        }
        if (other.getIngestedEventStatistics() == null ^ this.getIngestedEventStatistics() == null) {
            return false;
        }
        if (other.getIngestedEventStatistics() != null && !other.getIngestedEventStatistics().equals(this.getIngestedEventStatistics())) {
            return false;
        }
        if (other.getLastUpdatedTime() == null ^ this.getLastUpdatedTime() == null) {
            return false;
        }
        if (other.getLastUpdatedTime() != null && !other.getLastUpdatedTime().equals(this.getLastUpdatedTime())) {
            return false;
        }
        if (other.getCreatedTime() == null ^ this.getCreatedTime() == null) {
            return false;
        }
        if (other.getCreatedTime() != null && !other.getCreatedTime().equals(this.getCreatedTime())) {
            return false;
        }
        if (other.getArn() == null ^ this.getArn() == null) {
            return false;
        }
        return other.getArn() == null || other.getArn().equals(this.getArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getEventVariables() == null ? 0 : this.getEventVariables().hashCode());
        hashCode = 31 * hashCode + (this.getLabels() == null ? 0 : this.getLabels().hashCode());
        hashCode = 31 * hashCode + (this.getEntityTypes() == null ? 0 : this.getEntityTypes().hashCode());
        hashCode = 31 * hashCode + (this.getEventIngestion() == null ? 0 : this.getEventIngestion().hashCode());
        hashCode = 31 * hashCode + (this.getIngestedEventStatistics() == null ? 0 : this.getIngestedEventStatistics().hashCode());
        hashCode = 31 * hashCode + (this.getLastUpdatedTime() == null ? 0 : this.getLastUpdatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTime() == null ? 0 : this.getCreatedTime().hashCode());
        hashCode = 31 * hashCode + (this.getArn() == null ? 0 : this.getArn().hashCode());
        return hashCode;
    }

    public EventType clone() {
        try {
            return (EventType)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EventTypeMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

