/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.batch.model.FargatePlatformConfiguration;
import com.amazonaws.services.batch.model.KeyValuePair;
import com.amazonaws.services.batch.model.LinuxParameters;
import com.amazonaws.services.batch.model.LogConfiguration;
import com.amazonaws.services.batch.model.MountPoint;
import com.amazonaws.services.batch.model.NetworkConfiguration;
import com.amazonaws.services.batch.model.ResourceRequirement;
import com.amazonaws.services.batch.model.Secret;
import com.amazonaws.services.batch.model.Ulimit;
import com.amazonaws.services.batch.model.Volume;
import com.amazonaws.services.batch.model.transform.ContainerPropertiesMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ContainerProperties
implements Serializable,
Cloneable,
StructuredPojo {
    private String image;
    @Deprecated
    private Integer vcpus;
    @Deprecated
    private Integer memory;
    private List<String> command;
    private String jobRoleArn;
    private String executionRoleArn;
    private List<Volume> volumes;
    private List<KeyValuePair> environment;
    private List<MountPoint> mountPoints;
    private Boolean readonlyRootFilesystem;
    private Boolean privileged;
    private List<Ulimit> ulimits;
    private String user;
    private String instanceType;
    private List<ResourceRequirement> resourceRequirements;
    private LinuxParameters linuxParameters;
    private LogConfiguration logConfiguration;
    private List<Secret> secrets;
    private NetworkConfiguration networkConfiguration;
    private FargatePlatformConfiguration fargatePlatformConfiguration;

    public void setImage(String image) {
        this.image = image;
    }

    public String getImage() {
        return this.image;
    }

    public ContainerProperties withImage(String image) {
        this.setImage(image);
        return this;
    }

    @Deprecated
    public void setVcpus(Integer vcpus) {
        this.vcpus = vcpus;
    }

    @Deprecated
    public Integer getVcpus() {
        return this.vcpus;
    }

    @Deprecated
    public ContainerProperties withVcpus(Integer vcpus) {
        this.setVcpus(vcpus);
        return this;
    }

    @Deprecated
    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    @Deprecated
    public Integer getMemory() {
        return this.memory;
    }

    @Deprecated
    public ContainerProperties withMemory(Integer memory) {
        this.setMemory(memory);
        return this;
    }

    public List<String> getCommand() {
        return this.command;
    }

    public void setCommand(Collection<String> command) {
        if (command == null) {
            this.command = null;
            return;
        }
        this.command = new ArrayList<String>(command);
    }

    public ContainerProperties withCommand(String ... command) {
        if (this.command == null) {
            this.setCommand(new ArrayList<String>(command.length));
        }
        for (String ele : command) {
            this.command.add(ele);
        }
        return this;
    }

    public ContainerProperties withCommand(Collection<String> command) {
        this.setCommand(command);
        return this;
    }

    public void setJobRoleArn(String jobRoleArn) {
        this.jobRoleArn = jobRoleArn;
    }

    public String getJobRoleArn() {
        return this.jobRoleArn;
    }

    public ContainerProperties withJobRoleArn(String jobRoleArn) {
        this.setJobRoleArn(jobRoleArn);
        return this;
    }

    public void setExecutionRoleArn(String executionRoleArn) {
        this.executionRoleArn = executionRoleArn;
    }

    public String getExecutionRoleArn() {
        return this.executionRoleArn;
    }

    public ContainerProperties withExecutionRoleArn(String executionRoleArn) {
        this.setExecutionRoleArn(executionRoleArn);
        return this;
    }

    public List<Volume> getVolumes() {
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new ArrayList<Volume>(volumes);
    }

    public ContainerProperties withVolumes(Volume ... volumes) {
        if (this.volumes == null) {
            this.setVolumes(new ArrayList<Volume>(volumes.length));
        }
        for (Volume ele : volumes) {
            this.volumes.add(ele);
        }
        return this;
    }

    public ContainerProperties withVolumes(Collection<Volume> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public List<KeyValuePair> getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Collection<KeyValuePair> environment) {
        if (environment == null) {
            this.environment = null;
            return;
        }
        this.environment = new ArrayList<KeyValuePair>(environment);
    }

    public ContainerProperties withEnvironment(KeyValuePair ... environment) {
        if (this.environment == null) {
            this.setEnvironment(new ArrayList<KeyValuePair>(environment.length));
        }
        for (KeyValuePair ele : environment) {
            this.environment.add(ele);
        }
        return this;
    }

    public ContainerProperties withEnvironment(Collection<KeyValuePair> environment) {
        this.setEnvironment(environment);
        return this;
    }

    public List<MountPoint> getMountPoints() {
        return this.mountPoints;
    }

    public void setMountPoints(Collection<MountPoint> mountPoints) {
        if (mountPoints == null) {
            this.mountPoints = null;
            return;
        }
        this.mountPoints = new ArrayList<MountPoint>(mountPoints);
    }

    public ContainerProperties withMountPoints(MountPoint ... mountPoints) {
        if (this.mountPoints == null) {
            this.setMountPoints(new ArrayList<MountPoint>(mountPoints.length));
        }
        for (MountPoint ele : mountPoints) {
            this.mountPoints.add(ele);
        }
        return this;
    }

    public ContainerProperties withMountPoints(Collection<MountPoint> mountPoints) {
        this.setMountPoints(mountPoints);
        return this;
    }

    public void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
        this.readonlyRootFilesystem = readonlyRootFilesystem;
    }

    public Boolean getReadonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public ContainerProperties withReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
        this.setReadonlyRootFilesystem(readonlyRootFilesystem);
        return this;
    }

    public Boolean isReadonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public void setPrivileged(Boolean privileged) {
        this.privileged = privileged;
    }

    public Boolean getPrivileged() {
        return this.privileged;
    }

    public ContainerProperties withPrivileged(Boolean privileged) {
        this.setPrivileged(privileged);
        return this;
    }

    public Boolean isPrivileged() {
        return this.privileged;
    }

    public List<Ulimit> getUlimits() {
        return this.ulimits;
    }

    public void setUlimits(Collection<Ulimit> ulimits) {
        if (ulimits == null) {
            this.ulimits = null;
            return;
        }
        this.ulimits = new ArrayList<Ulimit>(ulimits);
    }

    public ContainerProperties withUlimits(Ulimit ... ulimits) {
        if (this.ulimits == null) {
            this.setUlimits(new ArrayList<Ulimit>(ulimits.length));
        }
        for (Ulimit ele : ulimits) {
            this.ulimits.add(ele);
        }
        return this;
    }

    public ContainerProperties withUlimits(Collection<Ulimit> ulimits) {
        this.setUlimits(ulimits);
        return this;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUser() {
        return this.user;
    }

    public ContainerProperties withUser(String user) {
        this.setUser(user);
        return this;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public ContainerProperties withInstanceType(String instanceType) {
        this.setInstanceType(instanceType);
        return this;
    }

    public List<ResourceRequirement> getResourceRequirements() {
        return this.resourceRequirements;
    }

    public void setResourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
        if (resourceRequirements == null) {
            this.resourceRequirements = null;
            return;
        }
        this.resourceRequirements = new ArrayList<ResourceRequirement>(resourceRequirements);
    }

    public ContainerProperties withResourceRequirements(ResourceRequirement ... resourceRequirements) {
        if (this.resourceRequirements == null) {
            this.setResourceRequirements(new ArrayList<ResourceRequirement>(resourceRequirements.length));
        }
        for (ResourceRequirement ele : resourceRequirements) {
            this.resourceRequirements.add(ele);
        }
        return this;
    }

    public ContainerProperties withResourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
        this.setResourceRequirements(resourceRequirements);
        return this;
    }

    public void setLinuxParameters(LinuxParameters linuxParameters) {
        this.linuxParameters = linuxParameters;
    }

    public LinuxParameters getLinuxParameters() {
        return this.linuxParameters;
    }

    public ContainerProperties withLinuxParameters(LinuxParameters linuxParameters) {
        this.setLinuxParameters(linuxParameters);
        return this;
    }

    public void setLogConfiguration(LogConfiguration logConfiguration) {
        this.logConfiguration = logConfiguration;
    }

    public LogConfiguration getLogConfiguration() {
        return this.logConfiguration;
    }

    public ContainerProperties withLogConfiguration(LogConfiguration logConfiguration) {
        this.setLogConfiguration(logConfiguration);
        return this;
    }

    public List<Secret> getSecrets() {
        return this.secrets;
    }

    public void setSecrets(Collection<Secret> secrets) {
        if (secrets == null) {
            this.secrets = null;
            return;
        }
        this.secrets = new ArrayList<Secret>(secrets);
    }

    public ContainerProperties withSecrets(Secret ... secrets) {
        if (this.secrets == null) {
            this.setSecrets(new ArrayList<Secret>(secrets.length));
        }
        for (Secret ele : secrets) {
            this.secrets.add(ele);
        }
        return this;
    }

    public ContainerProperties withSecrets(Collection<Secret> secrets) {
        this.setSecrets(secrets);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public ContainerProperties withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public void setFargatePlatformConfiguration(FargatePlatformConfiguration fargatePlatformConfiguration) {
        this.fargatePlatformConfiguration = fargatePlatformConfiguration;
    }

    public FargatePlatformConfiguration getFargatePlatformConfiguration() {
        return this.fargatePlatformConfiguration;
    }

    public ContainerProperties withFargatePlatformConfiguration(FargatePlatformConfiguration fargatePlatformConfiguration) {
        this.setFargatePlatformConfiguration(fargatePlatformConfiguration);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImage() != null) {
            sb.append("Image: ").append(this.getImage()).append(",");
        }
        if (this.getVcpus() != null) {
            sb.append("Vcpus: ").append(this.getVcpus()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getCommand() != null) {
            sb.append("Command: ").append(this.getCommand()).append(",");
        }
        if (this.getJobRoleArn() != null) {
            sb.append("JobRoleArn: ").append(this.getJobRoleArn()).append(",");
        }
        if (this.getExecutionRoleArn() != null) {
            sb.append("ExecutionRoleArn: ").append(this.getExecutionRoleArn()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes()).append(",");
        }
        if (this.getEnvironment() != null) {
            sb.append("Environment: ").append(this.getEnvironment()).append(",");
        }
        if (this.getMountPoints() != null) {
            sb.append("MountPoints: ").append(this.getMountPoints()).append(",");
        }
        if (this.getReadonlyRootFilesystem() != null) {
            sb.append("ReadonlyRootFilesystem: ").append(this.getReadonlyRootFilesystem()).append(",");
        }
        if (this.getPrivileged() != null) {
            sb.append("Privileged: ").append(this.getPrivileged()).append(",");
        }
        if (this.getUlimits() != null) {
            sb.append("Ulimits: ").append(this.getUlimits()).append(",");
        }
        if (this.getUser() != null) {
            sb.append("User: ").append(this.getUser()).append(",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: ").append(this.getInstanceType()).append(",");
        }
        if (this.getResourceRequirements() != null) {
            sb.append("ResourceRequirements: ").append(this.getResourceRequirements()).append(",");
        }
        if (this.getLinuxParameters() != null) {
            sb.append("LinuxParameters: ").append(this.getLinuxParameters()).append(",");
        }
        if (this.getLogConfiguration() != null) {
            sb.append("LogConfiguration: ").append(this.getLogConfiguration()).append(",");
        }
        if (this.getSecrets() != null) {
            sb.append("Secrets: ").append(this.getSecrets()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration()).append(",");
        }
        if (this.getFargatePlatformConfiguration() != null) {
            sb.append("FargatePlatformConfiguration: ").append(this.getFargatePlatformConfiguration());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerProperties)) {
            return false;
        }
        ContainerProperties other = (ContainerProperties)obj;
        if (other.getImage() == null ^ this.getImage() == null) {
            return false;
        }
        if (other.getImage() != null && !other.getImage().equals(this.getImage())) {
            return false;
        }
        if (other.getVcpus() == null ^ this.getVcpus() == null) {
            return false;
        }
        if (other.getVcpus() != null && !other.getVcpus().equals(this.getVcpus())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getCommand() == null ^ this.getCommand() == null) {
            return false;
        }
        if (other.getCommand() != null && !other.getCommand().equals(this.getCommand())) {
            return false;
        }
        if (other.getJobRoleArn() == null ^ this.getJobRoleArn() == null) {
            return false;
        }
        if (other.getJobRoleArn() != null && !other.getJobRoleArn().equals(this.getJobRoleArn())) {
            return false;
        }
        if (other.getExecutionRoleArn() == null ^ this.getExecutionRoleArn() == null) {
            return false;
        }
        if (other.getExecutionRoleArn() != null && !other.getExecutionRoleArn().equals(this.getExecutionRoleArn())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        if (other.getVolumes() != null && !other.getVolumes().equals(this.getVolumes())) {
            return false;
        }
        if (other.getEnvironment() == null ^ this.getEnvironment() == null) {
            return false;
        }
        if (other.getEnvironment() != null && !other.getEnvironment().equals(this.getEnvironment())) {
            return false;
        }
        if (other.getMountPoints() == null ^ this.getMountPoints() == null) {
            return false;
        }
        if (other.getMountPoints() != null && !other.getMountPoints().equals(this.getMountPoints())) {
            return false;
        }
        if (other.getReadonlyRootFilesystem() == null ^ this.getReadonlyRootFilesystem() == null) {
            return false;
        }
        if (other.getReadonlyRootFilesystem() != null && !other.getReadonlyRootFilesystem().equals(this.getReadonlyRootFilesystem())) {
            return false;
        }
        if (other.getPrivileged() == null ^ this.getPrivileged() == null) {
            return false;
        }
        if (other.getPrivileged() != null && !other.getPrivileged().equals(this.getPrivileged())) {
            return false;
        }
        if (other.getUlimits() == null ^ this.getUlimits() == null) {
            return false;
        }
        if (other.getUlimits() != null && !other.getUlimits().equals(this.getUlimits())) {
            return false;
        }
        if (other.getUser() == null ^ this.getUser() == null) {
            return false;
        }
        if (other.getUser() != null && !other.getUser().equals(this.getUser())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getResourceRequirements() == null ^ this.getResourceRequirements() == null) {
            return false;
        }
        if (other.getResourceRequirements() != null && !other.getResourceRequirements().equals(this.getResourceRequirements())) {
            return false;
        }
        if (other.getLinuxParameters() == null ^ this.getLinuxParameters() == null) {
            return false;
        }
        if (other.getLinuxParameters() != null && !other.getLinuxParameters().equals(this.getLinuxParameters())) {
            return false;
        }
        if (other.getLogConfiguration() == null ^ this.getLogConfiguration() == null) {
            return false;
        }
        if (other.getLogConfiguration() != null && !other.getLogConfiguration().equals(this.getLogConfiguration())) {
            return false;
        }
        if (other.getSecrets() == null ^ this.getSecrets() == null) {
            return false;
        }
        if (other.getSecrets() != null && !other.getSecrets().equals(this.getSecrets())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        if (other.getNetworkConfiguration() != null && !other.getNetworkConfiguration().equals(this.getNetworkConfiguration())) {
            return false;
        }
        if (other.getFargatePlatformConfiguration() == null ^ this.getFargatePlatformConfiguration() == null) {
            return false;
        }
        return other.getFargatePlatformConfiguration() == null || other.getFargatePlatformConfiguration().equals(this.getFargatePlatformConfiguration());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImage() == null ? 0 : this.getImage().hashCode());
        hashCode = 31 * hashCode + (this.getVcpus() == null ? 0 : this.getVcpus().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getCommand() == null ? 0 : this.getCommand().hashCode());
        hashCode = 31 * hashCode + (this.getJobRoleArn() == null ? 0 : this.getJobRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionRoleArn() == null ? 0 : this.getExecutionRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        hashCode = 31 * hashCode + (this.getEnvironment() == null ? 0 : this.getEnvironment().hashCode());
        hashCode = 31 * hashCode + (this.getMountPoints() == null ? 0 : this.getMountPoints().hashCode());
        hashCode = 31 * hashCode + (this.getReadonlyRootFilesystem() == null ? 0 : this.getReadonlyRootFilesystem().hashCode());
        hashCode = 31 * hashCode + (this.getPrivileged() == null ? 0 : this.getPrivileged().hashCode());
        hashCode = 31 * hashCode + (this.getUlimits() == null ? 0 : this.getUlimits().hashCode());
        hashCode = 31 * hashCode + (this.getUser() == null ? 0 : this.getUser().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getResourceRequirements() == null ? 0 : this.getResourceRequirements().hashCode());
        hashCode = 31 * hashCode + (this.getLinuxParameters() == null ? 0 : this.getLinuxParameters().hashCode());
        hashCode = 31 * hashCode + (this.getLogConfiguration() == null ? 0 : this.getLogConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getSecrets() == null ? 0 : this.getSecrets().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getFargatePlatformConfiguration() == null ? 0 : this.getFargatePlatformConfiguration().hashCode());
        return hashCode;
    }

    public ContainerProperties clone() {
        try {
            return (ContainerProperties)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ContainerPropertiesMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

