/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.premain;

import co.elastic.apm.agent.premain.BootstrapCheck;
import co.elastic.apm.agent.premain.common.JvmRuntimeInfo;

public class JavaVersionBootstrapCheck
implements BootstrapCheck {
    private final JvmRuntimeInfo runtimeInfo;

    public JavaVersionBootstrapCheck(JvmRuntimeInfo runtimeInfo) {
        this.runtimeInfo = runtimeInfo;
    }

    @Override
    public void doBootstrapCheck(BootstrapCheck.BootstrapCheckResult result) {
        if (!this.isJavaVersionSupported()) {
            result.addError(String.format("JVM version not supported: %s", this.runtimeInfo));
        }
    }

    public boolean isJavaVersionSupported() {
        if (this.runtimeInfo.getMajorVersion() < 7) {
            return false;
        }
        if (this.runtimeInfo.isHotSpot()) {
            return this.isHotSpotVersionSupported();
        }
        if (this.runtimeInfo.isIbmJ9()) {
            return this.isIbmJ9VersionSupported();
        }
        return true;
    }

    private boolean isHotSpotVersionSupported() {
        int updateVersion = this.runtimeInfo.getUpdateVersion();
        int majorVersion = this.runtimeInfo.getMajorVersion();
        if (updateVersion < 0) {
            return true;
        }
        int java7min = 60;
        int java8min = 40;
        if (this.runtimeInfo.isHpUx()) {
            java7min = 10;
            java8min = 2;
        }
        switch (majorVersion) {
            case 7: {
                return updateVersion >= java7min;
            }
            case 8: {
                return updateVersion >= java8min;
            }
        }
        return true;
    }

    private boolean isIbmJ9VersionSupported() {
        switch (this.runtimeInfo.getMajorVersion()) {
            case 7: {
                return false;
            }
            case 8: {
                return !"2.8".equals(this.runtimeInfo.getJavaVmVersion());
            }
        }
        return true;
    }
}

